// comshell.cpp




#include <tcl.h>

#include "coshd.h"
#include "ustring.h"

CTclScriptDisp* g_pTclScriptDisp = NULL;   // the global instance for this server

unsigned long g_dwCTclScriptCF = 0;

#ifdef REGISTER_ACTIVE
unsigned long g_dwRegisterCTclScript = 0;
#endif

static int ShutdownCmd(ClientData, Tcl_Interp*, int, char**);

//////////////////////////////////////////////////////////////////
//
HRESULT LoadTypeInfo(ITypeInfo** pptinfo, REFCLSID iid)
{                          
    HRESULT hr;
    LPTYPELIB ptlib = NULL;
    LPTYPEINFO ptinfo = NULL;

    *pptinfo = NULL;     
    
    // Load Type Library. 
    hr = LoadRegTypeLib(LIBID_COMSHELLD, 1, 0, 0x409, &ptlib);
    if (FAILED(hr)) {
      return hr;   
    }
    
    // Get type information for interface of the object.      
    hr = ptlib->GetTypeInfoOfGuid(iid, &ptinfo);
    if (FAILED(hr))  { 
        ptlib->Release();
        return hr;
    }   

    ptlib->Release();
    *pptinfo = ptinfo;
    return NOERROR;
}  

//////////////////////////////////////////////////////////////////
//
CTclScriptDisp* CTclScriptDisp::Create(Tcl_Interp* interp) 
{   
    HRESULT hr;
    CTclScriptDisp* psrvr = NULL;   
     
    // Create CTclScriptDisp Application object
    psrvr = new CTclScriptDisp();
    if (psrvr == NULL)
        return NULL;
   
     
    psrvr->m_cRef = 0;
	psrvr->m_interp = interp;
    

    // Load type information from type library. If required, notify user on failure. 
    hr = LoadTypeInfo(&psrvr->m_pTypeInfo, IID_ITclScriptDisp);
    if (FAILED(hr)) {
      goto error;
    }
         
    return psrvr;
    
error:                        
    if (psrvr->m_pTypeInfo) 
		psrvr->m_pTypeInfo->Release();
    
    // Set to NULL to prevent destructor from attempting to free again
    psrvr->m_pTypeInfo = NULL;
    
    delete psrvr;
    return NULL;
}

CTclScriptDisp::CTclScriptDisp(void)
{
	m_cRef=0;
}

CTclScriptDisp::~CTclScriptDisp (void)
{
	if (m_pTypeInfo)
		m_pTypeInfo->Release();
}



//---------------------------------------------------------------------
//                        IUnknown methods
//---------------------------------------------------------------------


STDMETHODIMP
CTclScriptDisp::QueryInterface(REFIID riid, void * * ppv)
{
    if(IsEqualIID(riid, IID_IUnknown) ||
		IsEqualIID(riid, IID_IDispatch) || 
		IsEqualIID(riid, IID_ITclScriptDisp) ){
      *ppv = this;
    }else {
      *ppv = NULL;	    
      return ResultFromScode(E_NOINTERFACE);
    }

    AddRef();
    return NOERROR;
}


STDMETHODIMP_(ULONG)
CTclScriptDisp::AddRef()
{
    return ++m_cRef;
}


STDMETHODIMP_(ULONG)
CTclScriptDisp::Release()
{
    if(--m_cRef == 0){
		try   // m_interp may not be valid here for a number of reasons
		{
			Tcl_Eval(m_interp,"after idle {comshell_shutdown; exit}");  
		}
		catch (...)
		{
			//...
		}
      delete this;
      return 0;
    }
    return m_cRef;
}


//---------------------------------------------------------------------
//                        IDispatch methods
//---------------------------------------------------------------------


STDMETHODIMP 
CTclScriptDisp::GetTypeInfo (UINT it, LCID lcid, ITypeInfo** ppti)
{
  *ppti = m_pTypeInfo;
  m_pTypeInfo->AddRef();
  return S_OK;
}

//////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptDisp::GetTypeInfoCount(UINT* pit)
{
  *pit = 1;
  return S_OK;
}

//////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptDisp::GetIDsOfNames(REFIID riid, OLECHAR** pNames, UINT cNames, 
	                       LCID lcid, DISPID* pdispids)
{
  return m_pTypeInfo->GetIDsOfNames(pNames,cNames,pdispids);
}

//////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptDisp::Invoke (DISPID id, REFIID riid, LCID lcid, 
					 WORD wFlags, DISPPARAMS* pd, VARIANT *pVarResult, 
					 EXCEPINFO* pe, UINT* pu)
{
	void* pvThis = static_cast<ITclScriptDisp*>(this);
	return m_pTypeInfo->Invoke(pvThis, id, wFlags, pd, pVarResult, pe, pu);
}

//---------------------------------------------------------------------
//                        ITclScript methods
//---------------------------------------------------------------------


STDMETHODIMP
CTclScriptDisp::eval(BSTR script, BSTR* result, long* retcode, BSTR* errorinfo)
{
	HRESULT hr = NOERROR;

	//===============pack BSTR in autoconverter class String816
	String816 strScript(script);    

	//===============eval the script

	*retcode = Tcl_Eval(m_interp, (char*)(const char*)strScript);

	if (m_interp->result[0]!=0)      // watch out - (""==NULL) in COM
	{
		String816 strResult = m_interp->result;
		*result = SysAllocString((const wchar_t*)strResult);   
	}

	if (*retcode!=TCL_OK)         // get errorInfo
	{
		char* errstr = Tcl_GetVar(m_interp,"errorInfo",TCL_GLOBAL_ONLY);
		if (errstr) 
		{
			String816 strErrorInfo = errstr;
			*errorinfo = SysAllocString((const wchar_t*)strErrorInfo);
		}
	}

	return hr;
}



//---------------------------------------------------------------------
//                      The CTclScriptDisp Class Factory
//---------------------------------------------------------------------


IClassFactory *
CTclScriptCF::Create()
{
    return new  CTclScriptCF();
}

////////////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptCF::QueryInterface(REFIID riid, void * * ppv)
{
    if(IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IClassFactory)){
      AddRef();
      *ppv = this;
      return NOERROR;
    }
    *ppv = NULL;
    return ResultFromScode(E_NOINTERFACE);
}


////////////////////////////////////////////////////////////////////////
STDMETHODIMP_(ULONG)
CTclScriptCF::AddRef()
{
    return ++m_refs;
}


////////////////////////////////////////////////////////////////////////
STDMETHODIMP_(ULONG)
CTclScriptCF::Release()
{
    if(--m_refs == 0){
      delete this;
      return 0;
    }
    return m_refs;
}

////////////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptCF::CreateInstance(
    IUnknown * /*punkOuter*/,
    REFIID riid,
    void * * ppv)
{
	extern CTclScriptDisp* g_pTclScriptDisp;

    return g_pTclScriptDisp->QueryInterface(riid, ppv);
}

////////////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptCF::LockServer(BOOL fLock)
{
    return NOERROR;
}




BOOL InitCom(Tcl_Interp* interp)
{
    HRESULT hresult;
    IClassFactory * pcf;


    if((hresult = CoInitialize(NULL)) != NOERROR)
      goto LError0;

	// create the single global instance of CTclScriptDisp
    if((g_pTclScriptDisp = CTclScriptDisp::Create(interp)) == NULL){
      hresult = ResultFromScode(E_OUTOFMEMORY);
      goto LError0;
    }
//	g_pTclScriptDisp->AddRef();

    if((pcf = CTclScriptCF::Create()) == NULL)
      goto LError1;

	//====================== class object registration
    hresult = CoRegisterClassObject(
      CLSID_comshelld,
      pcf,
      CLSCTX_LOCAL_SERVER,
      REGCLS_SINGLEUSE,
      &g_dwCTclScriptCF);

    if(hresult != NOERROR)
      goto LError2;

    
	//====================== active object (ROT) registration
#ifdef REGISTER_ACTIVE
	hresult = RegisterActiveObject(g_pTclScriptDisp, CLSID_comshell, 
								   ACTIVEOBJECT_WEAK, 
								   &g_dwRegisterCTclScript);
    if(hresult != NOERROR)
      goto LError2;
#endif

    pcf->Release();

	Tcl_CreateCommand(interp,"comshell_shutdown",ShutdownCmd,NULL,NULL);

    return TRUE;

LError2:;
    pcf->Release();

LError1:;
    UnInitCom();

LError0:;
    return (hresult=NOERROR);
}

//////////////////////////////////////////////////////////////////////////
BOOL UnInitCom()
{
#ifdef REGISTER_ACTIVE
    if(g_dwRegisterCTclScript != 0)
      RevokeActiveObject(g_dwRegisterCTclScript, NULL);
#endif
    
	if(g_dwCTclScriptCF != 0)
      CoRevokeClassObject(g_dwCTclScriptCF);


    CoUninitialize();

    return TRUE;
}

//////////////////////////////////////////////////////////////////////////
int ShutdownCmd(ClientData data, Tcl_Interp* interp, int argc, char** argv)
{
  UnInitCom();
  return TCL_OK;
}