//cosh.h

//#pragma warning(disable:4355)


// include the midl generated ITclScript header
#include "coshd_i.h"



class CTclScriptDisp : public ITclScriptDisp {
 
public:

  /* IUnknown methods */
  STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID  * ppvObj);
  STDMETHOD_(ULONG, AddRef)(THIS);
  STDMETHOD_(ULONG, Release)(THIS);

  /* IDispatch methods */
  STDMETHOD(GetTypeInfo)(UINT it, LCID lcid, ITypeInfo** ppti);
  STDMETHOD(GetTypeInfoCount)(UINT* pit);
  STDMETHOD(GetIDsOfNames)(REFIID riid, OLECHAR** pNames, UINT cNames, 
	                       LCID lcid, DISPID* pdispids);
  STDMETHOD(Invoke )(DISPID id, REFIID riid, LCID lcid, 
					 WORD wFlags, DISPPARAMS* pd, VARIANT *pVarResult, 
					 EXCEPINFO* pe, UINT* pu);

  /* ITclScript methods */
  STDMETHOD(eval)(BSTR script, BSTR* result, 
	              long* retcode, BSTR* errorinfo);

  CTclScriptDisp(void);
  virtual ~CTclScriptDisp (void);

  static CTclScriptDisp * Create(Tcl_Interp* interp);


 private:
	LONG m_cRef;
	ITypeInfo* m_pTypeInfo;
	Tcl_Interp* m_interp;
};


// the CTclScript Class Factory
//
class CTclScriptCF : public IClassFactory {
public:
    static IClassFactory * Create();

    STDMETHOD(QueryInterface)(REFIID riid, void * * ppv);
    STDMETHOD_(ULONG, AddRef)(void);
    STDMETHOD_(ULONG, Release)(void);

    STDMETHOD(CreateInstance)(
      IUnknown * punkOuter, REFIID riid, void * * ppv);
    STDMETHOD(LockServer)(BOOL fLock);

    CTclScriptCF() { m_refs = 1; }

private:
    ULONG m_refs;
};

extern BOOL InitCom(Tcl_Interp* interp);
extern BOOL UnInitCom(void);

extern CTclScriptDisp * g_pTclScriptDisp;

