# Ctcp IWANTOP implementation for NetPlug's IRC  - dl@hplyot.obspm.fr
# http://www.lyot.obspm.fr/~dl/netplug.html

# uptodate version should be as http://www.lyot.obspm.fr/~dl/iwantop.tcl

# customize the data at the end,
# copy in your .netplug dir and add   {$dotdir/iwantop.tcl} to your
# irc(autoload) list  
# (for instance put set irc(autoload) {{$dotdir/iwantop.tcl}} in your ircrc)

######## CODE ############

if {![string match "*OpMe*" $irc(destlist)]} {lappend irc(destlist) "OpMe"}

set ircAlias(OPME) {[if {$np==0} {set p $C}; return "CTCP $p IWANTOP"]}

proc iwo_add {exp channels} {
  global iwantop;
  set iwantop($exp) $channels;
}
#iwo_add  {^dl@hplyot\.obspm\.fr$} {#Eu-Opers #LinuxFr #NetPlug}

proc iwo_regquote {str} {
 regsub -all {\.} $str {\\.} str;
 set str;
}

proc iwo_sadd {uhost channels} {
  global iwantop;
  set iwantop(^[iwo_regquote $uhost]\$) $channels; 
}

array set ircCtcp {
  IWANTOP {
    global iwantop;
    set sid [array startsearch iwantop];
    set notfound 1;
    while {$notfound && [array anymore iwantop $sid]} {
      set el [array nextelement iwantop $sid];
#puts "{$el}/{$uhost}";
      if {[regexp $el $uhost]} {  
        set notfound 0;
        set oplst $iwantop($el);
	irc_fshow $n "+++ $from ($uhost) opping on $oplst" system;
        ctcp_reply $n $from $ctcpcmd " Opping you on $oplst";
        foreach opch $oplst {
          irc_send $n "MODE $opch +o $from";
        }
      }
    }
    array donesearch iwantop $sid;
    if {$notfound} {
      irc_fshow $n "+++ $from ($uhost) not found in IWANTOP list" error;
      ctcp_reply $n $from $ctcpcmd " Sorry, you are not in my list... ask !";
    }
  }
}


########## DATA ####################
catch {unset iwantop}
array set iwantop {
  {^scott@.*\.whoi\.edu$} {#Eu-Opers}
  {^john(pc@lsd|@pc)\.xs4all\.nl$} {#Eu-Opers}
  {^saouli@(www|irc)\.span\.ch$} {#Eu-Opers}
  {^trini@.*hartford1\.dialin\.ntplx\.com$} {#NetPlug}
  {^ra@.*\.hi\.is$} {#Eu-Opers}
  {^~?vegard@.+\.uninett\.no$} {#Eu-Opers}
  {^ruokonen@.*\.lut\.fi$} {#Eu-Opers}
  {^~?uhlar@.*\.ke\.sanet\.sk$} {#Eu-Opers}
  {^\^?dl@hplyot.obspm.fr} {#Eu-Opers #LinuxFr #NetPlug #Fr-Opers}
}

#iwo_sadd dl@hplyot.obspm.fr {#Eu-Opers #LinuxFr #NetPlug}
iwo_sadd eric@berenguier.rez-gif.supelec.fr {#NetPlug #LinuxFr}
iwo_sadd lesage@excalibur.univ-rouen.fr {#NetPlug #LinuxFr}
