#---------------------------------------------------------------------
# BETCL_main_script.tcl		- Intitialization of main backend
#				  Tcl interpreter.
#---------------------------------------------------------------------

#---------------------------------------------------------------------
# Use the following to disable Tcl function support for this database
#---------------------------------------------------------------------
#return -code error "Tcl functions disabled by postgres admin"

#---------------------------------------------------------------------
# Specify what default capabilities to enable in the slave
#---------------------------------------------------------------------
set HAVE_STDOUT		1
set HAVE_STDERR		1
set HAVE_EXECSQL	1
set HAVE_LOADTCL	1

#---------------------------------------------------------------------
# init_slave_interp		- Called from the betcl module to
#				  initialize the slave interpreter
#---------------------------------------------------------------------
proc init_slave_interp {path user} {
    global	HAVE_STDOUT
    global	HAVE_STDERR
    global	HAVE_EXECSQL
    global	HAVE_LOADTCL

    #-----------------------------------------------------------
    # Try to read the slave initialization script. If that
    # fails, SQL- and loadtcl capabilities are disabled.
    #-----------------------------------------------------------
    if {[catch {set fid [open "./BETCL_safe_script.tcl" r]} ]} {
        set HAVE_EXECSQL	0
	set HAVE_LOADTCL	0
	set safe_script 	""
    } else {
        set safe_script [read $fid]
	close $fid
    }

    #-----------------------------------------------------------
    # Share the requested stdio channels
    #-----------------------------------------------------------
    if {$HAVE_STDOUT} {
        interp share {} stdout $path
    }
    if {$HAVE_STDERR} {
        interp share {} stderr $path
    }

    #-----------------------------------------------------------
    # Install the required low level commands from the
    # betcl module.
    #-----------------------------------------------------------
    if {$HAVE_EXECSQL} {
        betcl_install_sql
    }
    if {$HAVE_LOADTCL} {
        betcl_install_load
    }

    #-----------------------------------------------------------
    # Build the final script to initialize the slave interpreter.
    # Store in global variables who is connected to the database
    # and which capabilities are enabled.
    #-----------------------------------------------------------
    set final_script ""
    append final_script "set PGUSER {$user}\n"
    append final_script "set HAVE_STDOUT  $HAVE_STDOUT\n"
    append final_script "set HAVE_STDERR  $HAVE_STDERR\n"
    append final_script "set HAVE_EXECSQL $HAVE_EXECSQL\n"
    append final_script "set HAVE_LOADTCL $HAVE_LOADTCL\n"
    append final_script "\n"
    append final_script $safe_script

    #-----------------------------------------------------------
    # Evaluate that in the slave
    #-----------------------------------------------------------
    interp eval $path $final_script

    #-----------------------------------------------------------
    # Call the site- and database specific init procs below
    #-----------------------------------------------------------
    site_specific_init $path $user
    db_specific_init   $path $user
}


#---------------------------------------------------------------------
# site_specific_init	- Perform site specific initialization
#---------------------------------------------------------------------
proc site_specific_init {path user} {
}


#---------------------------------------------------------------------
# db_specific_init	- Perform database specific initialization
#---------------------------------------------------------------------
proc db_specific_init {path user} {
}


