/**********************************************************************
 * betcl.h		- Postgres95 backend module for functions
 *			  written in Tcl
 *
 * IDENTIFICATION
 *  $Header: /usr/local/postgres95/src/libbetcl/RCS/betcl.h,v 0.1 1996/10/01 06:58:26 postgres95 Exp $
 *
 *    This software is copyrighted by Jan Wieck - Hamburg.
 *
 *    The author hereby grants permission  to  use,  copy,  modify,
 *    distribute,  and  license this software and its documentation
 *    for any purpose, provided that existing copyright notices are
 *    retained  in  all  copies  and  that  this notice is included
 *    verbatim in any distributions. No written agreement, license,
 *    or  royalty  fee  is required for any of the authorized uses.
 *    Modifications to this software may be  copyrighted  by  their
 *    author  and  need  not  follow  the licensing terms described
 *    here, provided that the new terms are  clearly  indicated  on
 *    the first page of each file where they apply.
 *
 *    IN NO EVENT SHALL THE AUTHOR OR DISTRIBUTORS BE LIABLE TO ANY
 *    PARTY  FOR  DIRECT,   INDIRECT,   SPECIAL,   INCIDENTAL,   OR
 *    CONSEQUENTIAL   DAMAGES  ARISING  OUT  OF  THE  USE  OF  THIS
 *    SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN
 *    IF  THE  AUTHOR  HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
 *    DAMAGE.
 *
 *    THE  AUTHOR  AND  DISTRIBUTORS  SPECIFICALLY   DISCLAIM   ANY
 *    WARRANTIES,  INCLUDING,  BUT  NOT  LIMITED  TO,  THE  IMPLIED
 *    WARRANTIES  OF  MERCHANTABILITY,  FITNESS  FOR  A  PARTICULAR
 *    PURPOSE,  AND NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON
 *    AN "AS IS" BASIS, AND THE AUTHOR  AND  DISTRIBUTORS  HAVE  NO
 *    OBLIGATION   TO   PROVIDE   MAINTENANCE,   SUPPORT,  UPDATES,
 *    ENHANCEMENTS, OR MODIFICATIONS.
 *
 * HISTORY
 * $Log: betcl.h,v $
 * Revision 0.1  1996/10/01 06:58:26  postgres95
 * Initial revision
 *
 *
 **********************************************************************/

#ifndef _BETCL_H_INCLUDED_
#define _BETCL_H_INCLUDED_

extern char *palloc(int size);
extern void pfree(void *);

#if defined(PORTNAME_linux) \
|| defined(PORTNAME_hpux) \
|| defined(PORTNAME_next) \
|| defined(WIN32)
#  define	betcl_jmp_buf		jmp_buf
#  define	betcl_setjmp(b)		setjmp(b)
#  define	betcl_longjmp(b, v)	longjmp(b, v)
#else
#  define	betcl_jmp_buf		sigjmp_buf
#  define	betcl_setjmp(b)		sigsetjmp(b, 1)
#  define	betcl_longjmp(b, v)	siglongjmp(b, v)
#endif


/**********************************************************************
 * For debugging
 **********************************************************************/
#define Debug(x)
/*
#define Debug(x)	fprintf x
*/


/**********************************************************************
 * This script file (if it exists) is loaded into the main interpreter 
 * after creation. Any time a safe interpreter is created the command
 * 'init_slave_interp <path> <pg_user_name>' is evaluated. 
 * This command can be used for aliasing and so on. If the file doesn't
 * exist a default 'init_slave_interp' proc is installed that just
 * shares the 'stderr' channel to the slave.
 * 
 * The current working directory of the backend is the database 
 * specific data directory under $(DATADIR). So you can setup different
 * initialization scripts for different databases.
 * 
 * WARNING!!!
 *
 * If you create security holes here, they might break the security
 * of all databases because the aliases will get executed under the
 * userid of the postgres superuser in a non-safe Tcl interpreter. 
 * So allowing 'exec' will give the database user full control over 
 * the postgres superuser.
 *
 **********************************************************************/
#define	BETCL_MAIN_SCRIPT	"./BETCL_main_script.tcl"


/**********************************************************************
 * We need to get back into the Tcl interpreter on transaction
 * aborts during queries that crash. So we need to modify the
 * restart address sometimes.
 **********************************************************************/
extern betcl_jmp_buf	Warn_restart;

/**********************************************************************
 * Informations we hold about Tcl procedures loaded
 **********************************************************************/
typedef struct betcl_proc_desc {
    char	proname[NAMEDATALEN + 1];
    int		pronargs;
} betcl_proc_desc;


/**********************************************************************
 * Informations about Tcl scripts sourced
 **********************************************************************/
typedef struct betcl_source_desc {
    char	srcname[NAMEDATALEN + 1];
} betcl_source_desc;


/**********************************************************************
 * Structure of our internal result buffer
 **********************************************************************/
typedef struct betcl_result {
    char	handle[32];
    int		interp_level;
    int		num_attrs;
    Tcl_DString	attributes;
    int		num_tuples;
    char	**tuple_strings;
} betcl_result;


/**********************************************************************
 * Function declarations
 **********************************************************************/
static void betcl_initall(void);
static void betcl_initmain(void);
static void betcl_initsafe(void);
static void betcl_load_source(char *srcname);
static void betcl_load_proc(NameData *proname, int4 nargs);

int4 betcl_reset(void);
int4 betcl_load(NameData *srcname);
text *betcl_call(NameData *proname, int4 nargs,
	text *a1, text *a2, text *a3, text *a4, text *a5, text *a6);

static int betcl_execsql(ClientData cdata, Tcl_Interp *interp, 
	int argc, char *argv[]);
static int betcl_sqlresult(ClientData cdata, Tcl_Interp *interp, 
	int argc, char *argv[]);
static int betcl_tclload(ClientData cdata, Tcl_Interp *interp, 
	int argc, char *argv[]);
static int betcl_install_load(ClientData cdata, Tcl_Interp *interp, 
	int argc, char *argv[]);
static int betcl_install_sql(ClientData cdata, Tcl_Interp *interp, 
	int argc, char *argv[]);

#endif
