.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds pq \fBPqatcl\fR
.ds sq \fBEpqpqa\fR
.ds tk \fBTcl/Tk\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH epqpqa \*(ms "Tcl-embedded Postquel for Pqatcl" "September 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
epqpqa \- Tcl-embedded Postquel for Pqatcl
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
The \*(sq package provides a simple way to directly execute
Postquel statements from the \*(tk level over the \*(pq package against a
\*(P4 database. It is what I call 'embedded Postquel'. 
.PP
The Postquel syntax is slightly enhanced for the 'retrieve' and 'fetch'
statements to loop over data retrieved from the database.
By default, these statements evaluate their last argument as
a Tcl script for any tuple retrieved. The special keyword 'single'
can be used to avoid this behaviour and the last argument becomes part
of the query. 

The Postquel syntax is modified. Because double quotes are special
quoting characters in Tcl, it is extremly hairy to type correctly
quoted queries. The Epqpqa package therefore expects literals embedded
in single quotes and substitutes them before sending the query to
the database backend.
 
Tuple data retrieved from the database is placed into Tcl variables.
The variable names are the column names returned by \*(P4 in the
portal. By default these are the original class column names, but
this might be overridden with 'name = ...' in the 'retrieve' statement.
.SH SYNOPSIS
\fBEPQconnect\fR ?\fIoptions\fR?
.PP
\fBEPQconnect\fR establishes a new database connection, creates
a wrapper command around that for the execution of embedded EPQ
and returns the command name. The \fIoptions\fR are exactly the
same as for \fBpqa_connect(\*(ms)\fR.
.PP
.SH SYNOPSIS
\fBEPQdisconnect\fR \fIwrap_command\fR
.PP
\fBEPQdisconnect\fR closes a database connection and removes the
wrapper command from the Tcl interpreter. \fIwrap_command\fR is the
return value of a previous call to \fBEPQconnect(\*(ms).
.SH SYNOPSIS
\fBEPQquote\fR \fIvalue\fR
.PP
\fBEPQquote\fR quotes special characters in a \fIvalue\fR like tabs
and newlines. The return value can safely be used in literals of an
EPQ statement.
.SH POSTQUEL ENHANCEMENTS
.PP
There are some new pseudo Postquel statements implemented in the
wrapper command. These statements gain large object access through
embedded Postquel and return information about database class structures
etc. They will get described here as soon as the set
is nearly complete. Up to now there are:

\fBcreate large object mode \fImode\fR
.br
\fImode\fR is a combination of \fBread\fR, \fBwrite\fR and \fBarchive\fR.
The return value is the \fBOID\fR of the large object created.

\fBremove large object \fIOID\fR
.br
The large object identified by \fIOID\fR is destroyed. The return value
is an empty string.

\fBopen large object \fIOID\fB mode \fImode\fR
.br
Open a Tcl channel to the large object identified by \fIOID\fR.
\fImode\fR is a combination of \fBread\fR, \fBwrite\fR and \fBarchive\fR.
The return value is a Tcl channel identifier to use in subsequent
I/O operations.

\fBinfo dbhandle\fR
.br
Return the \fBPqatcl\fR level database handle for the connection.

\fBdescribe class \fItablename\fR
.br
Retrieve information about the structure of a class. The return value
is a list of all the user defined columns of the class. Each entry is
a list giving the name, the \*(P4 field type and the internal field
length.
.SH REQUIREMENTS
.PP
The Pqatcl package 
.SH SEE ALSO
pqa_intro(\*(ms), pqa_connect(\*(ms)
.SH EXAMPLE
.nf
#!/bin/sh
# Start tclsh \\
exec tclsh "$0" "$@"

package require Epqpqa

#---------------------------------------------------------------------
# First create the test database
#---------------------------------------------------------------------
set tdb [EPQconnect -dbname template1 -port 4321]
$tdb createdb testdb_1
EPQdisconnect $tdb


#---------------------------------------------------------------------
# Now connect to the test database
#---------------------------------------------------------------------
set db [EPQconnect -dbname testdb_1 -port 4321]

#---------------------------------------------------------------------
# Create the classes
#---------------------------------------------------------------------
$db create usr (                \\
        uname    = char16,      \\
        uid      = int4,        \\
        realname = text)

$db create sys (sysname = char16, ipaddr = char16)
$db create adm (sysname = char16, uname  = char16)

#---------------------------------------------------------------------
# Load the test data
#---------------------------------------------------------------------
$db begin

$db append usr (uname = 'wieck', uid = 100, realname = 'Jan Wieck')
$db append usr (uname = 'guest', uid = 101, realname = 'Guest account')
$db append usr (uname = 'jones', uid = 102, realname = 'Tom Jones')

$db append sys (sysname = 'orion',   ipaddr = '53.2.130.192')
$db append sys (sysname = 'mars',    ipaddr = '53.2.130.17')
$db append sys (sysname = 'jupiter', ipaddr = '53.2.130.16')

$db append adm (sysname = 'orion',   uname = 'wieck')
$db append adm (sysname = 'mars',    uname = 'wieck')
$db append adm (sysname = 'jupiter', uname = 'wieck')
$db append adm (sysname = 'mars',    uname = 'jones')

$db end

#---------------------------------------------------------------------
# Now use that in some queries
#---------------------------------------------------------------------

$db begin

puts [format "%-20.20s %-16.16s" System IP-Addr]
puts [format "%-20.20s %-16.16s" -------------------- ----------------]

$db retrieve (sys.all) \\
        sort by sysname {
    puts [format "%-20.20s %-16.16s" $sysname $ipaddr]
}

puts ""

#---------------------------------------------------------------------

puts [format "%-20.20s %-16.16s" System Admin(s)]
puts [format "%-20.20s %-16.16s" -------------------- ----------------]

$db retrieve (system_name = sys.sysname)  \\
        sort by system_name {
    set admlist ""
    $db retrieve (U.uname, U.realname)    \\
            from U in usr, A in adm       \\
            where A.sysname = '$system_name' and U.uname = A.uname \\
            sort by uname {
        if {$admlist != ""} {
            append admlist ", "
        }
        append admlist "$uname ($realname)"
    }
    puts [format "%-20.20s %s" $system_name $admlist]
}

puts ""

#---------------------------------------------------------------------

puts [format "%-15.15s %-20.20s" User "Admin for system"]
puts [format "%-15.15s %-20.20s" --------------- --------------------]

$db retrieve (usr.uname) sort by uname {
    set syslist ""
    $db retrieve (adm.sysname)          \\
            where adm.uname = '$uname'  \\
            sort by sysname {

        #-----------------------------------------------------------
        # EPQ enhancement with 'single' keyword - this select
        # statement doesn't loop!!!
        #-----------------------------------------------------------
        $db retrieve single (sys.ipaddr) \\
            where sys.sysname = '$sysname'

        if {$syslist != ""} {
            append syslist ", "
        }
        append syslist "$sysname \\[$ipaddr\\]"
    }
    puts [format "%-15.15s %s" $uname $syslist]
}
$db retrieve single (usr.all) where usr.uname = '$uname'
puts "The last user was $uname UID=$uid ($realname)"

puts ""

$db end

#---------------------------------------------------------------------
# Finally close the testdatabase and destroy it
#---------------------------------------------------------------------
EPQdisconnect $db
set tdb [EPQconnect -dbname template1 -port 4321]
$tdb destroydb testdb_1
EPQdisconnect $tdb
