.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH pqa_close \*(ms "Asynchronous Tcl/Postgres interface" "June 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
pqa_close \- Close a Postgres connection
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SYNOPSIS
\fBpqa_close \fIconn\fR
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
.B Pqa_close(\*(ms)
closes the named database connection immediately. The connection
identifier becomes invalid an cannot be used any longer.
Existing result buffers are not destroyed. They must be explicitly
cleared by calls to \fBpqa_result(\*(ms)\fR.

For queries in progress, the status is set to '\fBfatal\fR' and
the corresponding call to \fBpqa_exec(\*(ms)\fR returns or
the associated callback procedure is evaluated prior to the
return of \fBpqa_close(\*(ms)\fR.

Large object channels currently open will report EIO on the
next required I/O operation of the channel driver.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH ARGUMENTS
.IP "\fIconn\fR" 6.0c
Specifies the database connection to close. The value must be
a valid connection identifier returned by a previous call of
\fBpqa_connect(\*(ms)\fR.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH RETURN VALUE
.PP
.B Pqa_close(\*(ms)
returns an empty string
or an error.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SEE ALSO
.PP
pqa_connect(\*(ms), pqa_result(\*(ms), pqa_lo_open(\*(ms),
postgres(1), postmaster(1)
