.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH pqa_connect \*(ms "Asynchronous Tcl/Postgres interface" "June 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
pqa_connect \- Connect to a Postgres database
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SYNOPSIS
\fBpqa_connect \fR?\fIoptions\fR?
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
.B Pqa_connect(\*(ms)
establishes a new connection to a \*(Pg database.
.B Pqa_connect(\*(ms)
guesses which version of \*(Pg (either \*(P4 or \*(P9) is used
for the database. Therefore, first a StartupPacket in \*(P4 format
is sent to the \*(pm and then an empty query is sent to the
backend. If that fails, a new connection is created and a
StartupInfo in \*(P9 format is sent to the \*(pm, again folowed
by an empty query. If a site has both versions of \*(Pg installed,
databases with equal names under both versions require the
\fB-port\fR option to be given or the \*(P4 database instance
will be used.

If the \fB-port\fR option is specified, possibly malformed
Startup messages will be sent to the \*(pm, resulting in a log
message 'no username specified' in the \*(pm logfile. These
errors aren't known to cause any trouble and could be ignored.

Normally it's best if the \*(Pg database in use is listening
on the standard port for the used version of \*(Pg.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH OPTIONS
.IP "\fB-databasename \fIname\fR" 6.0c
Specifies the name of the database to connect to. May be
alternatively given as '\fB-dbname\fR'. Defaults to the
environment variable \fBPGDATABASE\fR. If that isn't set
the current username (obtained by a lookup for the \fBUID\fR of
the process) is used as fallback.

.IP "\fB-host \fIhostname\fR"
Specifies the hostname where the \*(pm of the database
is running. Defaults to the environment variable \fBPGHOST\fR.
If that isn't set '\fBlocalhost\fR' is used as fallback.

.IP "\fB-port \fItcp-portnumber\fR"
Specifies the tcp-portnumber where the \*(pm of the
database is listening. Defaults to the environment variable \fBPGPORT\fR.
If that isn't set, \fBpqa_connect(\*(ms)\fR uses the standard
portnumber '\fB4321\fR' to connect to a \*(P4
database, and '\fB5432\fR' to connect to a \*(P9 database.

.IP "\fB-user \fIusername\fR"
Specifies the username to be sent in the Startup message to the
\*(pm. This may be overriden if an authentication system (like
Kerberos) is used.

.IP "\fB-tty \fIdebug-tty\fR"
Specifies the path of the debug tty information sent in the Startup
message to the \*(pm. See \fBpostgres(1)\fR for more information.

.IP "\fB-options \fIbackend-options\fR"
Specifies the additional options for the backend process.
See \fBpostgres(1)\fR for more information.

.IP "\fB-execfile \fIbackend-executable\fR"
Executable file to be started as backend by the \*(pm. This
is only useful if you're debugging \*(Pg.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH RETURN VALUE
.PP
.B Pqa_connect(\*(ms)
returns a unique identifier for the new database connection
or an error.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SEE ALSO
.PP
pqa_close(\*(ms), pqa_exec(\*(ms), pqa_lo_creat(\*(ms), pqa_lo_unlink(\*(ms),
pqa_lo_open(\*(ms), postgres(1), postmaster(1)
