.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH pqa_exec \*(ms "Asynchronous Tcl/Postgres interface" "June 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
pqa_exec \- Execute a query
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SYNOPSIS
\fBpqa_exec \fIconn query \fR?\fB-command \fIcmd\fR?
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
.B Pqa_exec(\*(ms)
sends \fIquery\fR to the database backend for the given
connection identifier for execution.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH ARGUMENTS
.IP "\fIconn\fR" 6.0c
Specifies the database connection to use for the query. The value must be
a valid connection identifier returned by a previous call of
\fBpqa_connect(\*(ms)\fR.

.IP "\fIquery\fR" 6.0c
String to send as a query to the database backend. The string must
contain a complete query in the appropriate query language for
the \*(Pg version of the connected backend (postquel for \*(P4 or
SQL for \*(P9). Values in the query should be quoted properly.
The query should not contain any newlines. If newlines are to be
used in tuple data, they should be converted into '\\n' sequences
prior to execution of the query.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH OPTIONS
.IP "\fB-command \fIcmd\fR" 6.0c
If given, \fBpqa_exec(\*(ms)\fR will immediately return an empty
string after
successfully submitting the query to the database backend. The query
results will be collected in background and \fIcmd\fR is evaluated
with an additional parameter - the result identifier - when the
query has finished or is aborted.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH RETURN VALUE
.PP
.B Pqa_exec(\*(ms)
returns an empty string if the \fB-command\fR option is given.
Otherwise it returns the identifier for the result buffer of the
query which could be analysed using \fBpqa_result(\*(ms)\fR.
If the connection identifier is invalid, or the connection to
the database backend is lost before transmitting the query, a
catchable Tcl-Error is generated.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SEE ALSO
.PP
pqa_connect(\*(ms), pqa_result(\*(ms),
postgres(1), postmaster(1)
