.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH pqa_intro \*(ms "Asynchronous Tcl/Postgres interface" "June 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
pqa_intro \- Asynchronous Tcl/Postgres interface
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
\fBPqa\fR is a loadable package to gain access to \*(Pg databases
from Tcl. In contrast to other implementations of \*(Pg interfaces,
\fBpqa\fR doesn't use the libpq.a access routines shipped with
\*(Pg. The frontend-/backend-protocol is directly implemented
in the package. It supports both, \*(P4 (the last official
release from the \*(Pg research project) and \*(P9. Therefore, \fBpqa\fR
is capable of handling multiple connections to the same or different
database instances on different hosts and different \*(Pg database
versions.

One of the major design rules for \fBpqa\fR was to hide some 
of the differences
between \*(P4 and \*(P9 inside the package.
Therefore, \fBpqa_connect\fR automatically detects the version
of the database during the initial handshaking with the \fBpostmaster\fR
and arranges for the communication to the backend to use the correct
frontend-/backend-protocol on a per connection base. Also additional
steps for large objects are done for \*(P4 connections
automatically so they are identified by
an object ID like in \*(P9.
What cannot be hidden
at this level, is the different query language (\fBpostquel\fR for \*(P4
and \fBSQL\fR for \*(P9). 

The internal architecture of the interface is
asynchronous. Even if the commands look like waiting for a query
or operation to complete, they are not blocking. 
Tcl will process events as if the
program is doing a \fBvwait\fR until the database responses are
received. The only real blocking operation is connecting to a
database backend. If working in the event driven world (e.g. Tk),
it's the programmers responsibility to disable parts of the
application to prevent races in query execution. 

Another difference to other implementations is the representation
of large objects. There are only three Tcl commands to access
large objects - \fBpqa_creat\fR and \fBpqa_unlink\fR to create
and destroy them, and \fBpqa_open\fR to open them. The data of
the large object is then accessed using standard Tcl commands
over the Tcl channel architecture.
