.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH pqa_lobj \*(ms "Asynchronous Tcl/Postgres interface" "June 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
pqa_lobj \- Large object access
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SYNOPSIS
\fBpqa_lo_creat \fIconn mode\fR
.br
\fBpqa_lo_unlink \fIconn oid\fR
.br
\fBpqa_lo_open \fIconn oid mode \fR?\fB-disconnect\fR?
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
These commands gain access to large object in a \*(Pg database.

For compatibility, only the inversion large object type of \*(P4
is available (as this is the only large object type for \*(P9), and
the identifier for large objects is an \fIOID\fR for both
versions of \*(Pg.
The path to the object in the \*(P4 namespace is built
in the virtual root as '\fB/pqaOID\fR'.
The class holding the large object data
is destroyed in addition to the unlink in \*(P4.

In contrast to other implementations of \*(Pg interfaces for
Tcl, no special commands for accessing the data of the large object
exist. \fBPqa_lo_open(\*(ms)\fR instead returns a Tcl channel to
the large object. This channel can be used in standard Tcl commands
like \fBgets\fR, \fBputs\fR, \fBread\fR, \fBseek\fR or \fBclose\fR.
If the database connection is lost or closed explicitly by the
program, subsequent operations on the channel report an I/O error.

There are some restrictions on the channel returned by
\fBpqa_lo_open(\*(ms)\fR. The I/O operations on the channel must
use the fast path funcionality of the \*(Pg frontend-/backend-protocol.
Thus, the channel cannot be used for input-/output-redirection
in the \fBexec\fR command. \*(Pg large object file descriptors
returned by the backend only support seek operations with an
offset from the beginning. So the channel too can only support
\fBseek set\fR. The normal mechanisms used by Tcl to determine
if a channel is ready for reading or writing cannot be used for
the frontend-/backend-protocol. Thus, asynchronous I/O and fileevents
don't work.
See also the introduction about the internal asynchronous
architecture of the pqa package.

Large object operations in \*(Pg require transaction block protection.
The pqa package traces the actual transaction state of the
connection and the large object commands automatically \fBbegin\fR and
\fBend\fR transactions as required. But this is done very simple, so
it is the programmers responsibility to build proper transaction
protection if multiple large objects should be accessed simultaneously
or if large object operations and normal queries should be used
intermixed on the connection.

There is a design bug in \*(Pg. The transaction
protection cannot roll back the destruction of a class
(\fBdestroy\fR in \*(P4, \fBdrop table\fR in \*(P9). Instead, only
the changes in the pg_class system catalog are rolled back, but the
files are already removed from the disk, leaving the system catalog
about classes in an inconsistent state. Due to the fact, that
each large object is stored in a class for it's own, this class
is destroyed on a call to \fBpqa_lo_unlink(\*(ms)\fR. \fBThis
destruction cannot be rolled back by the Postgres transaction control!\fR
Another difference in handling of large objects is, that
opening them write only doesn't truncate them to zero length.
Thus, the open/close sequence without any output would in fact
do nothing (in contrast to normal files).
.\"
.\" ---------------------------------------------------------------------
.\"
.SH ARGUMENTS
.IP "\fIconn\fR" 6.0c
Specifies the database connection to use for the query. The value must be
a valid connection identifier returned by a previous call of
\fBpqa_connect(\*(ms)\fR.

.IP "\fImode\fR" 6.0c
A Tcl list of "\fBINV_READ\fR", "\fBINV_WRITE\fR" and/or "\fBINV_ARCHIVE\fR".

.IP "\fIoid\fR" 6.0c
The object ID of the large object as returned by a previous
call to \fBpqa_lo_creat(\*(ms)\fR. 
.\"
.\" ---------------------------------------------------------------------
.\"
.SH OPTIONS
.IP "\fB-disconnect\fR" 6.0c
The Tcl channel architecture normally only
differs for the creation of a channel. After the channel type specific
commands are used to create the channel, the programmer should't
take care about any differences on the channel type, and existing
code should not require any modification. Using this option
arranges for the channel to automatically close the database connection
when the channel itself is closed. This database connection should
therefore not be used any longer for other access.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH RETURN VALUE
.PP
\fBPqa_lo_creat(\*(ms)\fR returns the object ID of the created
large object as unique identifier or a Tcl error is generated.

\fBPqa_lo_unlink(\*(ms)\fR returns an empty string or a Tcl error
is generated.

\fBPqa_lo_open(\*(ms)\fR returns a channel identifier for use
in subsequent Tcl I/O operations or a Tcl error is generated.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SEE ALSO
.PP
pqa_connect(\*(ms)
