.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH pqa_notify \*(ms "Asynchronous Tcl/Postgres interface" "June 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
pqa_notify \- Asynchronous portal notification access
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SYNOPSIS
\fBpqa_notify \fIconn \fR?\fB-command \fIcmd\fR?
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
.B Pqa_notify(\*(ms)
is used to control the asynchronous portal notification feature of
the \*(Pg database system.

Asynchronous portal notification as described in the \*(Pg
reference manual in fact is sent by the backend immediately
if any backend executes a '\fBnotify \fIclass\fR' query on a
class if the frontend is listening on that class.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH ARGUMENTS
.IP "\fIconn\fR" 6.0c
Specifies the database connection to use for the query. The value must be
a valid connection identifier returned by a previous call of
\fBpqa_connect(\*(ms)\fR.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH OPTIONS
.IP "\fB-command \fIcmd\fR" 6.0c
If given, \fIcmd\fR will be evaluated with the connection identifier
as additional parameter as soon as asynchronous portal notifications
arrive. If notifications are pending, \fIcmd\fR will be evaluated
immediately.

If \fIcmd\fR is an empty string, the callback mechanism is
disabled and further notifications will simply be collected.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH RETURN VALUE
.PP
.B Pqa_notify(\*(ms)
returns an empty string if the \fB-command\fR option is given.
Otherwise it returns a list of all class names, for which
notifications are received and resets this information in the
connection control structures. A class name may occur multiple
times in the list.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SEE ALSO
.PP
pqa_connect(\*(ms), 
postgres(1), postmaster(1), listen(n), notify(n)
