.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH pqa_result \*(ms "Asynchronous Tcl/Postgres interface" "June 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
pqa_result \- Examine query result buffers
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SYNOPSIS
\fBpqa_result \fIresult \fBoption\fR
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
.B Pqa_result(\*(ms)
returns various information about an executed database
query and/or clears the result buffer.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH ARGUMENTS
.IP "\fIresult\fR" 6.0c
Specifies the result buffer. The value must be
a valid result identifier returned by a previous call of
\fBpqa_exec(\*(ms)\fR or given as parameter to the Tcl command
assotiated with the finished query if the \fB-command\fR option
of \fBpqa_exec(\*(ms)\fR was used.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH OPTIONS
.PP
Except for the \fB-clear\fR option, all other options are
mutually exclusive.
.IP "\fB-status\fR" 6.0c
Returns the execution status of the query. This is one of
the values '\fBok\fR', '\fBerror\fR', '\fBfatal\fR', '\fBabort\fR', 
or '\fBlost\fR'.

For all other states than ok the errormsg should
be examined to get a hint for the reason.

.IP "\fB-connection\fR" 6.0c
Returns the connection identifier that produced this result
or an empty string if the connection is closed.

.IP "\fB-errormsg\fR" 6.0c
If the status isn't ok, returns the error reason as far as
the package knows it or what the backend sent as error message.
The error message may have several lines separated by linefeeds.

.IP "\fB-cmdreturn\fR" 6.0c
The command identifier as returned by the backend. Normally this
is the capitalized command name as interpreted by the backend.

.IP "\fB-portalname\fR" 6.0c
For queries returning tuple data, this returns the portal name
as given by the backend.

.IP "\fB-numtuples\fR" 6.0c
For queries returning tuple data, this returns the number
of received tuples.

.IP "\fB-attributes\fR" 6.0c
For queries returning tuple data, this returns a list describing
the attributes for each tuple. Each entry in the list is a sublist,
consisting of the attribute name, the database internal attribute
type and the database internal attribute length.

.IP "\fB-gettuple \fIn\fR" 6.0c
Returns the n-th tuple (starting at 0) returned by the query.
The return value is a list of attribute values in the order
of attributes given by the \fB-attributes\fR option.

.IP "\fB-clear\fR" 6.0c
The result buffer is cleared. All information about the
query is released and the result identifier will become invalid.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH RETURN VALUE
.PP
As described above.
.\"
.\" ---------------------------------------------------------------------
.\"
.SH SEE ALSO
.PP
pqa_connect(\*(ms), pqa_exec(\*(ms),
postgres(1)
