.ds Pg \fBPostgres\fR
.ds P4 \fBPostgres V4.2\fR
.ds P9 \fBPostgres95\fR
.ds Pm \fBPostmaster\fR
.ds pm \fBpostmaster\fR
.ds pq \fBPqatcl\fR
.ds sq \fBSqlpqa\fR
.ds tk \fBTcl/Tk\fR
.ds ms n
.\"
.\" ---------------------------------------------------------------------
.\"
.TH sqlpqa \*(ms "Tcl-embedded SQL for Pqatcl" "September 1996" "Pqa package for Tcl/Tk"
.nh
.\"
.\" ---------------------------------------------------------------------
.\"
.SH NAME
sqlpqa \- Tcl-embedded SQL for Pqatcl
.\"
.\" ---------------------------------------------------------------------
.\"
.SH DESCRIPTION
.PP
The \*(sq package provides a simple way to directly execute
SQL statements from the \*(tk level over the \*(pq package against a
\*(P9 database. It is what I call 'embedded SQL'. 
.PP
The SQL syntax is slightly enhanced for the 'select' and 'fetch'
statements to loop over data retrieved from the database.
By default, these statements evaluate their last argument as
a Tcl script for any tuple retrieved. The special keyword 'single'
can be used to avoid this behaviour and the last argument becomes part
of the query. 

Tuple data retrieved from the database is placed into Tcl variables.
The variable names are the column names returned by \*(P9 in the
portal. By default these are the original tables column names, but
this might be overridden with '... as name' in the 'select' statement.
.SH SYNOPSIS
\fBSQLconnect\fR ?\fIoptions\fR?
.PP
\fBSQLconnect\fR establishes a new database connection, creates
a wrapper command around that for the execution of embedded SQL
and returns the command name. The \fIoptions\fR are exactly the
same as for \fBpqa_connect(\*(ms)\fR.
.PP
.SH SYNOPSIS
\fBSQLdisconnect\fR \fIwrap_command\fR
.PP
\fBSQLdisconnect\fR closes a database connection and removes the
wrapper command from the Tcl interpreter. \fIwrap_command\fR is the
return value of a previous call to \fBSQLconnect(\*(ms).
.SH SYNOPSIS
\fBSQLquote\fR \fIvalue\fR
.PP
\fBSQLquote\fR quotes special characters in a \fIvalue\fR like tabs
and newlines. The return value can safely be used in literals of an
SQL statement.
.SH SQL ENHANCEMENTS
.PP
There are some new pseudo SQL statements implemented in the
wrapper command. These statements gain large object access through
embedded SQL and return information about database table structures
etc. They will get described here as soon as the set
is nearly complete. Up to now there are:

\fBcreate large object mode \fImode\fR
.br
\fImode\fR is a combination of \fBread\fR, \fBwrite\fR and \fBarchive\fR.
The return value is the \fBOID\fR of the large object created.

\fBdrop large object \fIOID\fR
.br
The large object identified by \fIOID\fR is destroyed. The return value
is an empty string.

\fBopen large object \fIOID\fB mode \fImode\fR
.br
Open a Tcl channel to the large object identified by \fIOID\fR.
\fImode\fR is a combination of \fBread\fR, \fBwrite\fR and \fBarchive\fR.
The return value is a Tcl channel identifier to use in subsequent
I/O operations.

\fBinfo dbhandle\fR
.br
Return the \fBPqatcl\fR level database handle for the connection.

\fBdescribe table \fItablename\fR
.br
Retrieve information about the structure of a table. The return value
is a list of all the user defined columns of the table. Each entry is
a list giving the name, the \*(P9 field type and the internal field
length.
.SH REQUIREMENTS
.PP
The Pqatcl package 
.SH SEE ALSO
pqa_intro(\*(ms), pqa_connect(\*(ms)
.SH EXAMPLE
.nf
#!/usr/bin/tclsh7.5

package require Sqlpqa

#---------------------------------------------------------------------
# First create the test database
#---------------------------------------------------------------------
set tdb [SQLconnect -dbname template1 -port 5432]
$tdb create database testdb_1
SQLdisconnect $tdb


#---------------------------------------------------------------------
# Now connect to the test database
#---------------------------------------------------------------------
set db [SQLconnect -dbname testdb_1 -port 5432]

#---------------------------------------------------------------------
# Create the tables
#---------------------------------------------------------------------
$db create table usr (          \\
        login   char16,         \\
        uid     int4,           \\
        realname text)

$db create table sys (sysname char16, ipaddr char16)
$db create table adm (sysname char16, login char16)

#---------------------------------------------------------------------
# Load the test data
#---------------------------------------------------------------------
$db begin

$db insert into usr values ('wieck', 100, 'Jan Wieck')
$db insert into usr values ('guest', 101, 'Guest account')
$db insert into usr values ('jones', 102, 'Tom Jones')

$db insert into sys values ('orion', '53.2.130.192')
$db insert into sys values ('mars', '53.2.130.17')
$db insert into sys values ('jupiter', '53.2.130.16')

$db insert into adm values ('orion', 'wieck')
$db insert into adm values ('mars', 'wieck')
$db insert into adm values ('jupiter', 'wieck')
$db insert into adm values ('mars', 'jones')

$db commit

#---------------------------------------------------------------------
# Now use that in some queries
#---------------------------------------------------------------------

$db begin

puts [format "%-20.20s %-16.16s" System IP-Addr]
puts [format "%-20.20s %-16.16s" -------------------- ----------------]

$db select * from sys    \\
        order by sysname {
    puts [format "%-20.20s %-16.16s" $sysname $ipaddr]
}

puts ""

#---------------------------------------------------------------------

puts [format "%-20.20s %-16.16s" System Admin(s)]
puts [format "%-20.20s %-16.16s" -------------------- ----------------]

$db select sysname as system_name from sys \\
        order by system_name {
    set admlist ""
    $db select U.login, U.realname      \\
            from usr U, adm A           \\
            where A.sysname = '$system_name' and U.login = A.login \\
            order by login {
        if {$admlist != ""} {
            append admlist ", "
	}
        append admlist "$login ($realname)"
    }
    puts [format "%-20.20s %s" $system_name $admlist]
}

puts ""

#---------------------------------------------------------------------

puts [format "%-15.15s %-20.20s" User "Admin for system"]
puts [format "%-15.15s %-20.20s" --------------- --------------------]

$db select login from usr order by login {
    set syslist ""
    $db select sysname from adm         \\
            where login = '$login'      \\
            order by sysname {

        #-----------------------------------------------------------
        # SQL enhancement with 'single' keyword - this select
        # statement doesn't loop!!!
        #-----------------------------------------------------------
        $db select single ipaddr from sys	\\
            where sysname = '$sysname'

        if {$syslist != ""} {
            append syslist ", "
        }
        append syslist "$sysname \\[$ipaddr\\]"
    }
    puts [format "%-15.15s %s" $login $syslist]
}
$db select single * from usr where login = '$login'
puts "The last user was $login UID=$uid ($realname)"

puts ""

$db commit

#---------------------------------------------------------------------
# Finally close the testdatabase and destroy it
#---------------------------------------------------------------------
SQLdisconnect $db
set tdb [SQLconnect -dbname template1 -port 5432]
$tdb drop database testdb_1
SQLdisconnect $tdb
