/**********************************************************************
 * $Source: /home/wieck/src/tcltk/extensions/pqatcl/libpqa/RCS/funcs.c,v $
 * $Revision: 0.1 $ $State: Stab $
 * $Date: 1996/06/20 17:57:11 $
 * $Author: wieck $
 *
 * DESCRIPTION
 * 	funcs.c			- Support functions
 *
 * HISTORY
 * $Log: funcs.c,v $
 * Revision 0.1  1996/06/20 17:57:11  wieck
 *   Initial revision
 *
 **********************************************************************/
char _RCSID_Pqa_funcs[] = "$Id: funcs.c,v 0.1 1996/06/20 17:57:11 wieck Stab $";


#include <tcl.h>
#include "pqatcl.h"


/**********************************************************************
 * pqatcl_get_arguments()	- Get the commandline arguments
 *				  of an operation
 **********************************************************************/
int pqatcl_get_arguments(Tcl_Interp *interp, PQA_argument *args,
		int argno, int argc, char *argv[])
{
    PQA_argument	*chk1;
    PQA_argument	*chk;
    int			l;

    /************************************************************
     * Process all options
     ************************************************************/
    while(argno < argc) {

        /************************************************************
         * Search for the variable control entry but check
         * for ambiguity and existance
         ************************************************************/
        chk1 = NULL;
        l = strlen(argv[argno]);
        for(chk = args; chk->argname; chk++) {
            if(!strncmp(chk->argname, argv[argno], l)) {
                if(chk1 != NULL) {
                    Tcl_AppendResult(interp, argv[0],
                        ": ambigous option '", argv[argno], "'", NULL);
                    return TCL_ERROR;
                }
                chk1 = chk;
            }
        }
        if(chk1 == NULL) {
	    Tcl_AppendResult(interp, argv[0],
		": unknown option '", argv[argno], "'", NULL);
	    return TCL_ERROR;
        }

        /************************************************************
         * Now process this option according to it's type
         ************************************************************/
        switch(chk1->argtype) {

            /************************************************************
             * Integer type - store the value
             ************************************************************/
            case PQA_ARGTYPE_INT:
            	if(++argno >= argc) {
            	    Tcl_AppendResult(interp, argv[0],
            	        ": option '", chk1->argname,
            	        "' requires a parameter", NULL);
            	    return TCL_ERROR;
            	}
            	if(Tcl_GetInt(interp, argv[argno], (int *)chk1->argvar)
            	    	!= TCL_OK) {
            	    return TCL_ERROR;
            	}
            	break;

            /************************************************************
             * Fixed integer type with value 0
             ************************************************************/
            case PQA_ARGTYPE_INTVAL0:
                *((int *)chk1->argvar) = 0;
                break;

            /************************************************************
             * Fixed integer type with value 1
             ************************************************************/
            case PQA_ARGTYPE_INTVAL1:
                *((int *)chk1->argvar) = 1;
                break;

            /************************************************************
             * Fixed integer type with value 2
             ************************************************************/
            case PQA_ARGTYPE_INTVAL2:
                *((int *)chk1->argvar) = 2;
                break;

            /************************************************************
             * Fixed integer type with value 3
             ************************************************************/
            case PQA_ARGTYPE_INTVAL3:
                *((int *)chk1->argvar) = 3;
                break;

            /************************************************************
             * Integer type - store the value
             ************************************************************/
            case PQA_ARGTYPE_DBL:
            	if(++argno >= argc) {
            	    Tcl_AppendResult(interp, argv[0],
            	        ": option '", chk1->argname,
            	        "' requires a parameter", NULL);
            	    return TCL_ERROR;
            	}
            	if(Tcl_GetDouble(interp, argv[argno], (double *)chk1->argvar)
            	    	!= TCL_OK) {
            	    return TCL_ERROR;
            	}
            	break;

            /************************************************************
             * String type - store the pointer to the value
             ************************************************************/
            case PQA_ARGTYPE_STR:
            	if(++argno >= argc) {
            	    Tcl_AppendResult(interp, argv[0],
            	        ": option '", chk1->argname,
            	        "' requires a parameter", NULL);
            	    return TCL_ERROR;
            	}
            	*((char **)(chk1->argvar)) = argv[argno];
            	break;

            /************************************************************
             * Unknown type - ? this is a BUG, not an error --- or is
             * a bug an error? 
             ************************************************************/
            default:
                Tcl_AppendResult(interp, argv[0],
                    " internal error - unknown param type for ", 
                    argv[argno], NULL);
                return TCL_ERROR;
        }

        argno++;
    }

    /************************************************************
     * Every argument went through, so maybe it's O.K.
     ************************************************************/
    return TCL_OK;
}


/**********************************************************************
 * pqatcl_getconnbyid()		- Lookup a connection by it's handle
 **********************************************************************/
PQA_connection *pqatcl_getconnbyid(Tcl_Interp *interp,
	PQA_client_data *cd, char *connid)
{
    Tcl_HashEntry *hash_ent;
    PQA_connection *conn;

    if((hash_ent = Tcl_FindHashEntry(&(cd->idtable), connid)) == NULL) {
        if(interp)
	    Tcl_AppendResult(interp, "\"", connid,
        		"\": invalid connection ID", NULL);
        return NULL;
    }

    conn = (PQA_connection *)Tcl_GetHashValue(hash_ent);
    if(conn->struct_type != PQA_STRUCT_CONNECTION) {
        if(interp)
	    Tcl_AppendResult(interp, "\"", connid,
        		"\": invalid connection ID", NULL);
        return NULL;
    }

    return conn;
}


/**********************************************************************
 * pqatcl_getresultbyid()		- Lookup a result by it's handle
 **********************************************************************/
PQA_result *pqatcl_getresultbyid(Tcl_Interp *interp,
	PQA_client_data *cd, char *resultid)
{
    Tcl_HashEntry *hash_ent;
    PQA_result *result;

    if((hash_ent = Tcl_FindHashEntry(&(cd->idtable), resultid)) == NULL) {
        if(interp)
	    Tcl_AppendResult(interp, "\"", resultid,
        		"\": invalid result ID", NULL);
        return NULL;
    }

    result = (PQA_result *)Tcl_GetHashValue(hash_ent);
    if(result->struct_type != PQA_STRUCT_RESULT) {
        if(interp)
	    Tcl_AppendResult(interp, "\"", resultid,
        		"\": invalid result ID", NULL);
        return NULL;
    }

    return result;
}


