/**********************************************************************
 * $Source: /home/wieck/src/tcltk/extensions/pqatcl/libpqa/RCS/init.c,v $
 * $Revision: 0.3 $ $State: Exp $
 * $Date: 1996/10/01 06:43:41 $
 * $Author: wieck $
 *
 * DESCRIPTION
 * 	init.c			- Initialization of Pqa package
 *
 * HISTORY
 * $Log: init.c,v $
 * Revision 0.3  1996/10/01 06:43:41  wieck
 * Changed function prefix from Pqa to Pqatcl.
 *
 * Revision 0.2  1996/08/23 10:25:14  wieck
 * Changed package name into Pqatcl
 *
 * Revision 0.1  1996/06/20 17:57:11  wieck
 *   Initial revision
 *
 **********************************************************************/
char _RCSID_Pqa_init[] = "$Id: init.c,v 0.3 1996/10/01 06:43:41 wieck Exp $";


#include <tcl.h>
#include "pqatcl.h"


/**********************************************************************
 * Pqatcl_Init()	- Initialize the Pqa package by allocating
 *			  the modul specific data and creating the
 *			  tcl commands in the calling interpreter.
 **********************************************************************/
int
Pqatcl_Init(Tcl_Interp *interp)
{
    ClientData		cdata;

    /************************************************************
     * Allocate and initialize the client data
     ************************************************************/
    cdata = ckalloc(sizeof(PQA_client_data));
    memset(cdata, 0, sizeof(PQA_client_data));
    ((PQA_client_data *)cdata)->struct_type = PQA_STRUCT_CDATA;
    ((PQA_client_data *)cdata)->interp      = interp;
    Tcl_InitHashTable(&(((PQA_client_data *)cdata)->idtable),
    	TCL_STRING_KEYS);

    /************************************************************
     * Create the commands
     ************************************************************/
    Tcl_CreateCommand(interp, "pqa_connect", Pqa_connect, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_close", Pqa_close, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_status", Pqa_status, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_exec", Pqa_exec, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_result", Pqa_result, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_loop", Pqa_loop, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_notify", Pqa_notify, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_lo_creat", Pqa_lo_creat, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_lo_unlink", Pqa_lo_unlink, cdata, NULL);
    Tcl_CreateCommand(interp, "pqa_lo_open", Pqa_lo_open, cdata, NULL);

    Tcl_PkgProvide(interp, "Pqatcl", PQA_VERSION);

    return TCL_OK;
}


/**********************************************************************
 * Postgres access can also be done in safe interpreters
 **********************************************************************/
int
Pqatcl_SafeInit(Tcl_Interp *interp)
{
    return Pqatcl_Init(interp);
}
