/**********************************************************************
 * $Source: /home/wieck/src/tcltk/extensions/pqatcl/libpqa/RCS/lobjio.c,v $
 * $Revision: 0.1 $ $State: Stab $
 * $Date: 1996/06/20 17:57:11 $
 * $Author: wieck $
 *
 * DESCRIPTION
 * 	lobjio.c		- Large object interface channel
 *				  handling routines
 *
 * HISTORY
 * $Log: lobjio.c,v $
 * Revision 0.1  1996/06/20 17:57:11  wieck
 *   Initial revision
 *
 **********************************************************************/
char _RCSID_Pqa_lobjio[] = "$Id: lobjio.c,v 0.1 1996/06/20 17:57:11 wieck Stab $";

#include <tcl.h>
#include "pqatcl.h"


/**********************************************************************
 * pqatcl_lobj_blockmode()	- Nonblocking IO currently unsupported
 **********************************************************************/
int pqatcl_lobj_blockmode(ClientData idata,
		Tcl_File infile, Tcl_File outfile, int mode)
{
    /*
    PQA_large_obj	*lobj = (PQA_large_obj *)idata;
    */

    return EINVAL;
}


/**********************************************************************
 * pqatcl_lobj_close()		- Close callback for channel
 **********************************************************************/
int pqatcl_lobj_close(ClientData idata, Tcl_Interp *interp,
		Tcl_File infile, Tcl_File outfile)
{
    PQA_large_obj	*lobj = (PQA_large_obj *)idata;
    PQA_fnarg	close_arg[1];
    int		retval = 0;

    /************************************************************
     * Wait until the database is ready
     ************************************************************/
    if(lobj->conn) {
        while(lobj->conn->status != PQA_QSTATUS_IDLE) {
            if(lobj->conn->status == PQA_QSTATUS_LOST) {
                return EPIPE;
            }
            Tcl_DoOneEvent(TCL_ALL_EVENTS);
        }
    }

    /************************************************************
     * We still need a connection that is alive
     ************************************************************/
    if(lobj->conn != NULL && lobj->conn->status != PQA_QSTATUS_LOST) {
        if(interp == NULL) {
            interp = lobj->cdata->interp;
        }

        /************************************************************
         * Set the connection busy
         ************************************************************/
        lobj->conn->status = PQA_QSTATUS_LOGETID;
        lobj->conn->large_obj_current = lobj;
	lobj->status = PQA_QSTATUS_BUSY;

	/************************************************************
	 * Send the close request to the backend
	 ************************************************************/
	close_arg[0].len    = 4;
	close_arg[0].isint  = 1;
	close_arg[0].u.iarg = lobj->backend_fd;

	if(pqatcl_lobj_sendfunc(lobj->conn, lobj->conn->lobj_fnid_close,
		4, 1, close_arg) < 0) {
	    Tcl_AppendResult(interp, PQerrormsg, NULL);
	    retval = EIO;
	} else {
	    while(lobj->status == PQA_QSTATUS_BUSY) {
	        Tcl_DoOneEvent(TCL_ALL_EVENTS);
	    }
	    if(lobj->status != PQA_QSTATUS_DONE) {
	        Tcl_AppendResult(interp, Tcl_DStringValue(&(lobj->errormsg)),
	        		NULL);
	        retval = EIO;
	    }
	}
	lobj->conn->status = PQA_QSTATUS_IDLE;
	lobj->conn->large_obj_current = NULL;

	/************************************************************
	 * Do the auto_end if requested
	 ************************************************************/
	if(lobj->auto_end || lobj->auto_disconnect) {
	    if(Tcl_VarEval(interp, "pqa_exec ", lobj->conn->handle,
	    		" end", NULL) == TCL_ERROR) {
	    	retval = EIO;
	    }
	    if(Tcl_VarEval(interp, "pqa_result ", interp->result,
	    		" -clear", NULL) == TCL_ERROR) {
	    	retval = EIO;
	    }
	}

	/************************************************************
	 * Do the auto_disconnect if requested
	 ************************************************************/
	if(lobj->auto_disconnect) {
	    if(Tcl_VarEval(interp, "pqa_close ", lobj->conn->handle,
	    		NULL) == TCL_ERROR) {
	    	retval = EIO;
	    }
	}
    } else {
        retval = EPIPE;
    }

    /************************************************************
     * We're done with this channel - free our instance data
     ************************************************************/
    if(lobj->prev == NULL) {
        if(lobj->conn != NULL) {
            lobj->conn->large_obj_list = lobj->next;
        }
    } else {
        lobj->prev->next = lobj->next;
    }
    if(lobj->next != NULL) {
        lobj->next->prev = lobj->prev;
    }
    Tcl_DStringFree(&(lobj->errormsg));
    ckfree(lobj);

    return retval;
}


/**********************************************************************
 * pqatcl_lobj_input()		- Input callback for channel
 **********************************************************************/
int pqatcl_lobj_input(ClientData idata,
		Tcl_File infile, char *buf, int bufsize,
		int *errorcode)
{
    PQA_large_obj	*lobj = (PQA_large_obj *)idata;
    PQA_fnarg		input_arg[2];
    int			retval;

    /************************************************************
     * Wait until the database is ready
     ************************************************************/
    if(lobj->conn) {
        while(lobj->conn->status != PQA_QSTATUS_IDLE) {
            if(lobj->conn->status == PQA_QSTATUS_LOST) {
                return EPIPE;
            }
            Tcl_DoOneEvent(TCL_ALL_EVENTS);
        }
    }
    if(lobj->conn == NULL || lobj->conn->status == PQA_QSTATUS_LOST) {
        *errorcode = EPIPE;
        return -1;
    }

    /************************************************************
     * Maximum read size is 4K
     ************************************************************/
    if(bufsize > 4096) {
        bufsize = 4096;
    }

    /************************************************************
     * Set the connection busy
     ************************************************************/
    lobj->status = PQA_QSTATUS_BUSY;
    lobj->conn->status = PQA_QSTATUS_LOGETID;
    lobj->conn->large_obj_current = lobj;

    /************************************************************
     * Call lo_read()
     ************************************************************/
    input_arg[0].len    = 4;
    input_arg[0].isint  = 1;
    input_arg[0].u.iarg = lobj->backend_fd;

    input_arg[1].len    = 4;
    input_arg[1].isint  = 1;
    input_arg[1].u.iarg = bufsize;

    if(pqatcl_lobj_sendfunc(lobj->conn, lobj->conn->lobj_fnid_read,
    		bufsize, 2, input_arg) < 0) {
        *errorcode = EIO;
        retval = -1;
    } else {
        while(lobj->status == PQA_QSTATUS_BUSY) {
            Tcl_DoOneEvent(TCL_ALL_EVENTS);
        }
        if(lobj->status != PQA_QSTATUS_DONE) {
            *errorcode = EIO;
            retval = -1;
        } else {
            retval = lobj->inbuf;
            memcpy(buf, lobj->buf, retval);
        }
    }

    /************************************************************
     * Reset the connection to IDLE
     ************************************************************/
    lobj->conn->status = PQA_QSTATUS_IDLE;
    lobj->conn->large_obj_current = NULL;

    return retval;
}


/**********************************************************************
 * pqatcl_lobj_output()		- Output callback for channel
 **********************************************************************/
int pqatcl_lobj_output(ClientData idata,
		Tcl_File outfile, char *buf, int bufsize,
		int *errorcode)
{
    PQA_large_obj	*lobj = (PQA_large_obj *)idata;
    PQA_fnarg		output_arg[2];
    int			retval = 0;

    /************************************************************
     * Wait until the database is ready
     ************************************************************/
    if(lobj->conn) {
        while(lobj->conn->status != PQA_QSTATUS_IDLE) {
            if(lobj->conn->status == PQA_QSTATUS_LOST) {
                return EPIPE;
            }
            Tcl_DoOneEvent(TCL_ALL_EVENTS);
        }
    }
    if(lobj->conn == NULL || lobj->conn->status == PQA_QSTATUS_LOST) {
        *errorcode = EPIPE;
        return -1;
    }

    /************************************************************
     * Drain the buffer (maybe partial)
     ************************************************************/
    while(bufsize > 0) {
        if(bufsize > 4096) {
            retval = 4096;
        } else {
            retval = bufsize;
        }
        lobj->status = PQA_QSTATUS_BUSY;
        lobj->conn->status = PQA_QSTATUS_LOGETID;
        lobj->conn->large_obj_current = lobj;

        output_arg[0].len    = 4;
        output_arg[0].isint  = 1;
        output_arg[0].u.iarg = lobj->backend_fd;
        
        output_arg[1].len    = retval;
        output_arg[1].isint  = 0;
        output_arg[1].u.parg = buf;

        if(pqatcl_lobj_sendfunc(lobj->conn, lobj->conn->lobj_fnid_write,
        	4, 2, output_arg) < 0) {
            *errorcode = EIO;
            retval = -1;
            break;
        }
        while(lobj->status == PQA_QSTATUS_BUSY) {
            Tcl_DoOneEvent(TCL_ALL_EVENTS);
        }
        if(lobj->status != PQA_QSTATUS_DONE) {
            *errorcode = EIO;
            retval = -1;
        }
	break;
    }

    lobj->conn->status = PQA_QSTATUS_IDLE;
    lobj->conn->large_obj_current = NULL;

    return retval;
}


/**********************************************************************
 * pqatcl_lobj_seek()		- Seek callback for channel
 **********************************************************************/
int pqatcl_lobj_seek(ClientData idata,
		Tcl_File infile, Tcl_File outfile,
		long offset, int whence,
		int *errorcode)
{
    PQA_large_obj	*lobj = (PQA_large_obj *)idata;
    PQA_fnarg		seek_arg[3];
    int			retval = 0;
    int			i;
    int			shift;

    /************************************************************
     * Postgres V4.2 only supports L_SET - backward compatibility
     ************************************************************/
    if(whence != 0) {
        *errorcode = EINVAL;
        return -1;
    }

    /************************************************************
     * Wait until the database is ready
     ************************************************************/
    if(lobj->conn) {
        while(lobj->conn->status != PQA_QSTATUS_IDLE) {
            if(lobj->conn->status == PQA_QSTATUS_LOST) {
                return EPIPE;
            }
            Tcl_DoOneEvent(TCL_ALL_EVENTS);
        }
    }
    if(lobj->conn == NULL || lobj->conn->status == PQA_QSTATUS_LOST) {
        *errorcode = EPIPE;
        return -1;
    }

    lobj->status = PQA_QSTATUS_BUSY;
    lobj->conn->status = PQA_QSTATUS_LOGETID;
    lobj->conn->large_obj_current = lobj;

    seek_arg[0].len    = 4;
    seek_arg[0].isint  = 1;
    seek_arg[0].u.iarg = lobj->backend_fd;
    
    seek_arg[1].len    = 4;
    seek_arg[1].isint  = 1;
    seek_arg[1].u.iarg = (int)offset;

    seek_arg[2].len    = 4;
    seek_arg[2].isint  = 1;
    seek_arg[2].u.iarg = 0;

    if(pqatcl_lobj_sendfunc(lobj->conn, lobj->conn->lobj_fnid_lseek,
	    4, 3, seek_arg) < 0) {
	*errorcode = EIO;
	retval = -1;
    } else {
	while(lobj->status == PQA_QSTATUS_BUSY) {
	    Tcl_DoOneEvent(TCL_ALL_EVENTS);
	}
	if(lobj->status != PQA_QSTATUS_DONE) {
	    *errorcode = EIO;
	    retval = -1;
	} else {
	    retval = 0;
	    for(i = 0, shift = 0; i < 4; i++, shift += 8) {
		retval |= ((lobj->buf[i]) & 0xFF) << shift;
	    }
	}
    }

    lobj->conn->status = PQA_QSTATUS_IDLE;
    lobj->conn->large_obj_current = NULL;

    return retval;
}


#if 0
int pqatcl_lobj_setoption(ClientData idata,
		Tcl_Interp *interp, char *option, char *value)
{
    PQA_large_obj	*lobj = (PQA_large_obj *)idata;

printf("lobj_setoption called for channel %s\n", lobj->handle);
    return 0;
}


int pqatcl_lobj_getoption(ClientData idata,
		char *option, Tcl_DString *retval)
{
    PQA_large_obj	*lobj = (PQA_large_obj *)idata;

printf("lobj_getoption called for channel %s\n", lobj->handle);
    return 0;
}
#endif
