/**********************************************************************
 * $Source: /home/wieck/src/tcltk/extensions/pqatcl/libpqa/RCS/pqatcl.h,v $
 * $Revision: 0.2 $ $State: Exp $
 * $Date: 1996/10/01 06:44:20 $
 * $Author: wieck $
 *
 * DESCRIPTION
 * 	Definitions for pqatcl
 *
 * HISTORY
 * $Log: pqatcl.h,v $
 * Revision 0.2  1996/10/01 06:44:20  wieck
 * Changed function prefixes from Pqa to Pqatcl.
 *
 * Revision 0.1  1996/06/20 17:56:36  wieck
 *   Initial revision
 *
 **********************************************************************/

#ifndef _PQTCL_H_INCLUDED_
#define _PQTCL_H_INCLUDED_

#include <tcl.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>


/**********************************************************************
 * The following are definitions from the headers
 * of postgres.
 *
 * WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!!
 * WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!!
 * WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!!
 *
 * THESE DEFINITIONS REFLECT THOSE IN THE ORIGINAL DISTRIBUTION
 * OF POSTGRES V4.2 AND POSTGRES95. THE HEADERS OF YOUR POSTGRES
 * INSTALLATION AREN'T INCLUDED. IF YOU MADE CHANGES, OR IF FUTURE
 * RELEASES OF POSTGRES DON'T MATCH THESE DEFINITIONS THIS PACKAGE
 * IS UNABLE TO CONNECT TO THE DATABASE BACKEND.
 **********************************************************************/
#define PQA_ERRORMSG_LENGTH	4096
#define PQA_INITIAL_SEQNO_4_2	1
#define PQA_POSTPORT_4_2	"4321"
#define PQA_POSTPORT_95		"5432"
#define PQA_NAMEDATALEN_4_2	16
#define PQA_NAMEDATALEN_95	32
#define PQA_PATH_SIZE		64
#define PQA_ARGV_SIZE		64
#define PQA_INITIAL_SEQNO_4_2	1
#define PQA_INVALID_ID		(-1)
#define PQA_STATUS_OK		(0)
#define PQA_STARTUP_MSG		7

#define PQA_INV_ARCHIVE		0x00010000
#define PQA_INV_WRITE		0x00020000
#define PQA_INV_READ		0x00040000
#define PQA_Inversion		0

#define PQA_VAR_LENGTH_ARG_4_2	(-5)
#define PQA_VAR_LENGTH_RES_4_2	(-1)

typedef struct PacketHdr_4_2 {
    int		seqno;
    int		len;
    int		connId;
    int		type;
} PacketHdr_4_2;

typedef struct StartupPacket_4_2 {
    PacketHdr_4_2 hdr;
    char	database[PQA_PATH_SIZE];
    char	user[PQA_NAMEDATALEN_4_2];
    char	options[PQA_ARGV_SIZE];
    char	execFile[PQA_ARGV_SIZE];
    char	tty[PQA_PATH_SIZE];
} StartupPacket_4_2;

typedef struct StartupPacket_95 {
    char	database[PQA_PATH_SIZE];
    char	user[PQA_NAMEDATALEN_95];
    char	options[PQA_ARGV_SIZE];
    char	execFile[PQA_ARGV_SIZE];
    char	tty[PQA_PATH_SIZE];
} StartupPacket_95;

#define PQA_MAX_PACKET_SIZE_4_2	(2*1024)
#define PQA_MESSAGE_SIZE_4_2	(PQA_MAX_PACKET_SIZE_4_2 - sizeof(PacketHdr_4_2))
#define PQA_MESSAGE_SIZE_95	(sizeof(StartupPacket_95) + 5)

typedef struct PacketBufHdr_4_2 {
    int		id, prev, next;
} PacketBufHdr_4_2;

typedef struct PacketBuf_4_2 {
    int		id, prev, next;
    char	data[PQA_MESSAGE_SIZE_4_2 - sizeof(PacketBufHdr_4_2)];
} PacketBuf_4_2;

typedef struct PacketBuf_95 {
    int		len;
    int		msgtype;
    char	data[PQA_MESSAGE_SIZE_95];
} PacketBuf_95;

extern char PQerrormsg[];



/**********************************************************************
 * Definitions 
 **********************************************************************/
#define PQA_VERSION		"1.0"
#define PQA_RECV_BUFFER_SIZE	16384
#define PQA_NAME_LENGTH		64

#define	PQA_DBVERSION_4_2	0
#define PQA_DBVERSION_95	1

enum {
    PQA_ARGTYPE_INT,
    PQA_ARGTYPE_INTVAL0,
    PQA_ARGTYPE_INTVAL1,
    PQA_ARGTYPE_INTVAL2,
    PQA_ARGTYPE_INTVAL3,
    PQA_ARGTYPE_DBL,
    PQA_ARGTYPE_STR
};

enum {
    PQA_QSTATUS_IDLE,
    PQA_QSTATUS_LOST,
    PQA_QSTATUS_BUSY,
    PQA_QSTATUS_GETID,
    PQA_QSTATUS_GETPID,
    PQA_QSTATUS_TATTR,
    PQA_QSTATUS_TDATA,
    PQA_QSTATUS_ERROR,
    PQA_QSTATUS_FATAL,
    PQA_QSTATUS_ABORT,
    PQA_QSTATUS_DATA,
    PQA_QSTATUS_DONE,

    PQA_QSTATUS_LOGETID
};

enum {
    PQA_STRUCT_CONNECTION,
    PQA_STRUCT_RESULT,
    PQA_STRUCT_LARGE_OBJ,
    PQA_STRUCT_CDATA
};

/**********************************************************************
 * PQA_result		- Result buffer returned by queries
 **********************************************************************/
typedef struct PQA_result {
    int		struct_type;		/* Struct type			*/
    struct PQA_connection *conn;	/* Pointer back to conn		*/
    struct PQA_client_data *cdata;	/* Pointer back to cdata	*/
    char	handle[32];		/* Handle for this result	*/

    int		status;			/* Query status			*/
    char	c_ret[PQA_NAME_LENGTH];	/* Command from result		*/
    char	p_ret[PQA_NAME_LENGTH];	/* Portal name from res		*/
    Tcl_DString	errormsg;		/* Error from backend		*/
    int		num_attrs;		/* Number of attributes to have	*/
    int		have_attrs;		/* Number of attributes we have	*/
    Tcl_DString	attributes;		/* Attribute description	*/

    int		num_tuples;		/* Number of tuples we got	*/
    int		alloc_tuples;		/* Size of tuple_strings	*/
    char	**tuple_strings;	/* The tuples themself		*/
    Tcl_DString	tuple_current;		/* The current tuple		*/

    char	*async_command;		/* Eval when query complete	*/

    struct PQA_result *prev;		/* Double link to all result	*/
    struct PQA_result *next;		/* buffers for this connection	*/
} PQA_result;

/**********************************************************************
 * PQA_large_obj	- Control structure for large objects
 **********************************************************************/
typedef struct PQA_large_obj {
    int		struct_type;		/* Struct type			*/
    struct PQA_connection *conn;	/* Pointer back to conn		*/
    struct PQA_client_data *cdata;	/* Pointer back to cdata	*/
    char	handle[32];		/* Handle for this object	*/

    int		status;			/* Query status			*/
    Tcl_DString	errormsg;		/* Errors			*/
    int		auto_end;		/* End transaction on close	*/
    int		auto_disconnect;	/* Disconnect on close		*/

    Tcl_Channel	pqa_channel;		/* Tcl channel to large object	*/
    int		backend_fd;		/* Backend filedescriptor	*/
    int		oid;			/* The object ID		*/
    char	buf[4096];		/* Data buffer			*/
    int		inbuf;			/* How much is in buf		*/

    struct PQA_large_obj *prev;		/* Double link to all object	*/
    struct PQA_large_obj *next;		/* buffers for this connection	*/
} PQA_large_obj;

/**********************************************************************
 * PQA_connection	- Connection control block
 **********************************************************************/
typedef struct PQA_connection {
    int		struct_type;		/* Structure type		*/
    struct PQA_client_data *cdata;	/* Pointer back to cdata	*/
    char	handle[32];		/* Handle for this connection	*/
    Tcl_Channel	backend;		/* Tcl channel to backend	*/
    int		backend_version;	/* Whether 4.2 or 95		*/

    int		status;			/* Query status			*/
    int		transaction_state;	/* Flag that follows begin/end	*/
    int		dummy_queries;		/* Part of the damn fe-be-prot	*/
    int		xactid;			/* Current transaction ID	*/
    char	recv_buf[PQA_RECV_BUFFER_SIZE]; /* Buf to get results	*/
    int		recv_have;		/* How much is in recv_buf	*/
    char	field_bitmap[128];	/* Bitfield for current tuple	*/
    int		field_bmsize;		/* Current query bitmap size	*/
    int		field_no;		/* Current field number		*/

    int		notify_pending;		/* Are there async notifies?	*/
    Tcl_DString	notify_list;		/* List of notifications	*/
    char	*notify_command;	/* Tcl cmd to eval for notifies	*/
    int		notify_active;		/* notify_command is executing	*/

    PQA_result	*result_list;		/* Link to result buffers	*/
    PQA_large_obj *large_obj_list;	/* Link to object buffers	*/
    PQA_large_obj *large_obj_current;	/* Current large object		*/

    int		lobj_initialized;	/* Initialize only once		*/
    int		lobj_fnid_creat;	/* FunctionID lo_creat		*/
    int		lobj_fnid_open;		/* FunctionID lo_open		*/
    int		lobj_fnid_close;	/* FunctionID lo_close		*/
    int		lobj_fnid_lseek;	/* FunctionID lo_lseek		*/
    int		lobj_fnid_tell;		/* FunctionID lo_tell		*/
    int		lobj_fnid_read;		/* FunctionID lo_read		*/
    int		lobj_fnid_write;	/* FunctionID lo_write		*/
    int		lobj_fnid_unlink;	/* FunctionID lo_unlink		*/
} PQA_connection;

/**********************************************************************
 * PQA_client_data	- Package specific data per interpreter
 **********************************************************************/
typedef struct PQA_client_data {
    int		struct_type;
    int		conn_id;
    int		result_id;
    int		large_obj_id;
    Tcl_Interp	*interp;
    Tcl_HashTable idtable;
} PQA_client_data;

/**********************************************************************
 * PQA_fnarg		- Argument structure used for
 *			  pqatcl_lobj_sendfunc()
 **********************************************************************/
typedef struct PQA_fnarg {
    int		len;
    int		isint;
    union {
        char	*parg;
        int	iarg;
    } u;
} PQA_fnarg;

/**********************************************************************
 * PQA_argument		- Generic argument description structure
 *			  for Tcl-callable functions
 **********************************************************************/
typedef struct PQA_argument {
    char	*argname;
    int		argtype;
    void	*argvar;
} PQA_argument;


/**********************************************************************
 * Functions in pqa_init.c
 **********************************************************************/
EXTERN int	Pqatcl_Init _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int	Pqatcl_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));

/**********************************************************************
 * Functions in pqa_connect.c
 **********************************************************************/
EXTERN int	Pqa_connect _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

EXTERN int	Pqa_close _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

EXTERN int	Pqa_status _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

/**********************************************************************
 * Functions in pqa_exec.c
 **********************************************************************/
EXTERN int	Pqa_exec _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

EXTERN int	Pqa_notify _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

EXTERN void	pqatcl_exec_asyncIO _ANSI_ARGS_((ClientData cdata,
			int mask));

EXTERN int	pqatcl_exec_getresult _ANSI_ARGS_((Tcl_Interp *interp,
			PQA_connection *conn,
			PQA_result *result,
			char *buf, int len));

EXTERN int	pqatcl_send_simple _ANSI_ARGS_((PQA_connection *conn,
			char type, int id, char *msg));

/**********************************************************************
 * Functions in pqa_lobj.c
 **********************************************************************/
EXTERN int	Pqa_lo_creat _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

EXTERN int	Pqa_lo_unlink _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

EXTERN int	Pqa_lo_open _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

EXTERN int	pqatcl_lobj_getresult _ANSI_ARGS_((Tcl_Interp *interp,
			PQA_connection *conn,
			char *buf, int len));

EXTERN int	pqatcl_lobj_init _ANSI_ARGS_((Tcl_Interp *interp,
			PQA_client_data *cd,
			PQA_connection *conn));

EXTERN int	pqatcl_lobj_sendfunc _ANSI_ARGS_((PQA_connection *conn,
			int fnid, int reslen, int argc,
			PQA_fnarg *argv));

/**********************************************************************
 * Functions in pqa_lobjio.c
 **********************************************************************/
EXTERN int	pqatcl_lobj_blockmode _ANSI_ARGS_((ClientData idata,
			Tcl_File infile,
			Tcl_File outfile,
			int mode));

EXTERN int	pqatcl_lobj_close _ANSI_ARGS_((ClientData idata,
			Tcl_Interp *interp,
			Tcl_File infile,
			Tcl_File outfile));

EXTERN int	pqatcl_lobj_input _ANSI_ARGS_((ClientData idata,
			Tcl_File infile,
			char *buf, int bufsize,
			int *errorcode));

EXTERN int	pqatcl_lobj_output _ANSI_ARGS_((ClientData idata,
			Tcl_File outfile,
			char *buf, int bufsize,
			int *errorcode));

EXTERN int	pqatcl_lobj_seek _ANSI_ARGS_((ClientData idata,
			Tcl_File infile,
			Tcl_File outfile,
			long offset, int whence,
			int *errorcode));

EXTERN int	pqatcl_lobj_setoption _ANSI_ARGS_((ClientData idata,
			Tcl_Interp *interp,
			char *option, char *value));

EXTERN int	pqatcl_lobj_getoption _ANSI_ARGS_((ClientData idata,
			char *option,
			Tcl_DString *retval));

/**********************************************************************
 * Functions in pqa_result.c
 **********************************************************************/
EXTERN int	Pqa_result _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

EXTERN int	Pqa_loop _ANSI_ARGS_((ClientData cdata,
			Tcl_Interp *interp,
			int argc, char *argv[]));

extern void	pqatcl_result_clear _ANSI_ARGS_((PQA_result *result));

/**********************************************************************
 * Functions in pqa_funcs.c
 **********************************************************************/
EXTERN int	pqatcl_get_arguments _ANSI_ARGS_((Tcl_Interp *interp,
			PQA_argument *args,
			int argno, int argc, char *argv[]));

EXTERN PQA_connection *pqatcl_getconnbyid _ANSI_ARGS_ ((Tcl_Interp *interp,
			PQA_client_data *cd,
			char *connid));

EXTERN PQA_result *pqatcl_getresultbyid _ANSI_ARGS_ ((Tcl_Interp *interp,
			PQA_client_data *cd,
			char *resultid));

#endif /* _PQTCL_H_INCLUDED */
