/**********************************************************************
 * $Source: /home/wieck/src/tcltk/extensions/pqatcl/libpqa/RCS/result.c,v $
 * $Revision: 0.1 $ $State: Stab $
 * $Date: 1996/06/20 17:57:11 $
 * $Author: wieck $
 *
 * DESCRIPTION
 * 	result.c		- Examine the result buffer of a
 *				  query.
 *
 * HISTORY
 * $Log: result.c,v $
 * Revision 0.1  1996/06/20 17:57:11  wieck
 *   Initial revision
 *
 **********************************************************************/
char _RCSID_pqa_result[] = "$Id: result.c,v 0.1 1996/06/20 17:57:11 wieck Stab $";

#include <tcl.h>
#include "pqatcl.h"


/**********************************************************************
 * Pqa_result()			- The Tcl pqa_result command
 **********************************************************************/
int Pqa_result(ClientData cdata, Tcl_Interp *interp, int argc, char *argv[])
{
    PQA_client_data *cd = (PQA_client_data *)cdata;
    PQA_connection *conn;
    PQA_result	  *result;
    Tcl_HashEntry *hash_ent;
    char	statbuf[32];

    int i;
    static int	f_status;
    static int f_connection;
    static int f_errormsg;
    static int f_command;
    static int f_portalname;
    static int f_numtuples;
    static int f_attributes;
    static int f_gettuple;
    static int f_clear;
    static PQA_argument args[] = {
        { "-status", PQA_ARGTYPE_INTVAL1, &f_status },
        { "-connection", PQA_ARGTYPE_INTVAL1, &f_connection },
        { "-errormsg", PQA_ARGTYPE_INTVAL1, &f_errormsg },
        { "-cmdreturn", PQA_ARGTYPE_INTVAL1, &f_command },
        { "-portalname", PQA_ARGTYPE_INTVAL1, &f_portalname },
        { "-numtuples", PQA_ARGTYPE_INTVAL1, &f_numtuples },
        { "-attributes", PQA_ARGTYPE_INTVAL1, &f_attributes },
        { "-gettuple", PQA_ARGTYPE_INT, &f_gettuple },
        { "-clear", PQA_ARGTYPE_INTVAL1, &f_clear },
        { NULL, 0, NULL }
    };

    f_status = 0;
    f_connection = 0;
    f_errormsg = 0;
    f_command = 0;
    f_portalname = 0;
    f_numtuples = 0;
    f_attributes = 0;
    f_gettuple = -1;
    f_clear = 0;

    /************************************************************
     * Check if we have at least the result
     ************************************************************/
    if(argc < 2) {
        Tcl_AppendResult(interp, argv[0], ": syntax error '",
        	argv[0], " result_id ?-option ...?'", NULL);
        return TCL_ERROR;
    }

    /************************************************************
     * Get the result buffer and it's connection
     ************************************************************/
    if((result = pqatcl_getresultbyid(interp, cd, argv[1])) == NULL) {
        return TCL_ERROR;
    }
    conn = result->conn;

    /************************************************************
     * Parse options
     ************************************************************/
    if(pqatcl_get_arguments(interp, args, 2, argc, argv) != TCL_OK) {
        return TCL_ERROR;
    }

    /************************************************************
     * Check for syntax
     ************************************************************/
    i = f_status + f_connection + f_errormsg + f_portalname + 
    	f_command + f_numtuples + f_attributes;
    if(i > 1 || (i > 0 && f_gettuple >= 0)) {
        Tcl_AppendResult(interp, argv[0], 
        	": except -clear all options are mutually exclusive",
        	NULL);
        return TCL_ERROR;
    }

    /************************************************************
     * Return the status of the query
     ************************************************************/
    if(f_status) {
        switch(result->status) {
        case PQA_QSTATUS_DATA:
        case PQA_QSTATUS_DONE:	strcpy(statbuf, "ok");
        			break;
        case PQA_QSTATUS_FATAL:	strcpy(statbuf, "fatal");
        			break;
        case PQA_QSTATUS_ERROR:	strcpy(statbuf, "error");
        			break;
        case PQA_QSTATUS_ABORT:	strcpy(statbuf, "abort");
        			break;
        case PQA_QSTATUS_LOST:	strcpy(statbuf, "lost");
        			break;
        default:		strcpy(statbuf, "unknown");
        			break;
        }
        Tcl_SetResult(interp, statbuf, TCL_VOLATILE);
    }

    /************************************************************
     * Return the connection this result came from
     ************************************************************/
    if(f_connection) {
        if(conn) {
	    Tcl_SetResult(interp, conn->handle, TCL_VOLATILE);
        } else {
	    Tcl_SetResult(interp, "", TCL_VOLATILE);
        }
    }

    /************************************************************
     * Return the last error message from the backend
     ************************************************************/
    if(f_errormsg) {
        Tcl_SetResult(interp, 
        	Tcl_DStringValue(&(result->errormsg)), 
        	TCL_VOLATILE);
    }

    /************************************************************
     * Return the portal name as given by the backend
     ************************************************************/
    if(f_portalname) {
        Tcl_SetResult(interp, result->p_ret, TCL_VOLATILE);
    }

    /************************************************************
     * Return the command name as given by the backend
     ************************************************************/
    if(f_command) {
        Tcl_SetResult(interp, result->c_ret, TCL_VOLATILE);
    }

    /************************************************************
     * Return the number of tuples in the buffer
     ************************************************************/
    if(f_numtuples) {
        sprintf(statbuf, "%d", result->num_tuples);
        Tcl_SetResult(interp, statbuf, TCL_VOLATILE);
    }

    /************************************************************
     * Return the attribute names and types
     ************************************************************/
    if(f_attributes) {
        if(result->have_attrs == 0) {
	    Tcl_SetResult(interp, "", TCL_VOLATILE);
        } else {
	    Tcl_SetResult(interp, Tcl_DStringValue(&(result->attributes)),
	    	TCL_VOLATILE);
        }
    }

    /************************************************************
     * Return the values of one tuple
     ************************************************************/
    if(f_gettuple >= 0) {
        if(f_gettuple >= result->num_tuples) {
            Tcl_AppendResult(interp, argv[0], ": illegal tupel number", NULL);
            return TCL_ERROR;
        }
        Tcl_SetResult(interp, 
        	result->tuple_strings[f_gettuple],
        	TCL_VOLATILE);
    }

    /************************************************************
     * Clear the result buffer if requested
     ************************************************************/
    if(f_clear) {
        /************************************************************
         * Free all the data
         ************************************************************/
        Tcl_DStringFree(&(result->errormsg));
        Tcl_DStringFree(&(result->attributes));
        for(i = 0; i < result->num_tuples; i++) {
            ckfree(result->tuple_strings[i]);
        }
        ckfree(result->tuple_strings);
        if(result->async_command) {
            ckfree(result->async_command);
        }
        /************************************************************
         * Remove it from the double linked list
         ************************************************************/
        if(result->next) {
            result->next->prev = result->prev;
        }
        if(result->prev) {
            result->prev->next = result->next;
        } else {
            if(conn) {
                conn->result_list = result->next;
            }
        }
        /************************************************************
         * Destroy the hash value and the result itself
         ************************************************************/
        hash_ent = Tcl_FindHashEntry(&(cd->idtable), argv[1]);
        Tcl_DeleteHashEntry(hash_ent);
        ckfree(result);
    }

    return TCL_OK;
}


/**********************************************************************
 * Pqa_loop()			- The Tcl pqa_loop command
 **********************************************************************/
int Pqa_loop(ClientData cdata, Tcl_Interp *interp, int argc, char *argv[])
{
    PQA_client_data *cd = (PQA_client_data *)cdata;
    PQA_connection  *conn;
    PQA_result	    *result;
    char	    retbuf[32];

    int i;
    int done;
    int ret;

    /************************************************************
     * Check if we have the result, the listname and the command
     ************************************************************/
    if(argc != 4) {
        Tcl_AppendResult(interp, argv[0], ": syntax error '",
        	argv[0], " result_id listname command'", NULL);
        return TCL_ERROR;
    }

    /************************************************************
     * Get the result buffer and it's connection
     ************************************************************/
    if((result = pqatcl_getresultbyid(interp, cd, argv[1])) == NULL) {
        return TCL_ERROR;
    }
    conn = result->conn;

    /************************************************************
     * Check that the status of the result is O.K.
     ************************************************************/
    if(result->status != PQA_QSTATUS_DONE && 
    		result->status != PQA_QSTATUS_DATA) {
        Tcl_AppendResult(interp, argv[0], 
            ": Result buffer in error condition", NULL);
        return TCL_ERROR;
    }

    /************************************************************
     * Now loop over the results
     ************************************************************/
    done = 0;
    for(i = 0; i < result->num_tuples; i++) {
        /************************************************************
         * Set the loop list variable
         ************************************************************/
        if(Tcl_SetVar(interp, argv[2], 
                result->tuple_strings[i],
                TCL_LEAVE_ERR_MSG) == NULL) {
            return TCL_ERROR;
        }

        /************************************************************
         * Execute the command and do what the return value 
         * is meant to be done
         ************************************************************/
        ret = Tcl_Eval(interp, argv[3]);
        switch(ret) {
            case TCL_OK:
            case TCL_CONTINUE:
            	break;

            case TCL_BREAK:
            	done++;
            	break;

            case TCL_RETURN:
            	return TCL_RETURN;

            case TCL_ERROR:
            	return TCL_ERROR;

            default:
            	sprintf(retbuf, "%d", ret);
            	Tcl_AppendResult(interp, "Unexpected return value ",
            		retbuf, " from Tcl_Eval()", NULL);
            	return TCL_ERROR;
        }

	if(pqatcl_getresultbyid(NULL, cd, argv[1]) == NULL || done) {
	    break;
	}
    }

    return TCL_OK;
}
