#
#
#


proc cb_class_setup {into} {
    global	class_frame
    global	xxx
    set xxx 0

    set f $into.f_class
    set class_frame $f

    frame	$f -borderwidth 2 -relief sunken
    label	$f.lbl -text "Class selection"			\
    		-anchor w -borderwidth 0 -relief flat
    frame	$f.f_list -borderwidth 0 -relief flat

    listbox	$f.f_list.list -width 20 -height 20		\
    		-borderwidth 1 -relief sunken			\
    		-yscrollcommand "$f.f_list.scrolly set"		\
    		-selectmode single

    scrollbar	$f.f_list.scrolly -orient vertical		\
    		-width 11 -borderwidth 2 -relief sunken		\
    		-command "$f.f_list.list yview"

    pack	$f.f_list.scrolly -side right -fill y		\
    		-padx 0 -pady 0
    pack	$f.f_list.list -side left -fill both		\
    		-expand true -padx 0 -pady 0
    pack	$f.lbl -side top -fill x -padx 0 -pady 0
    pack	$f.f_list -side left -fill both -expand true	\
    		-padx 0 -pady 0

    bind $f.f_list.list <ButtonRelease-1> "+cb_class_show"

    return $f
}


proc cb_class_clear {} {
    upvar #0 class_frame f

    $f.f_list.list delete 0 end
}


proc cb_class_update {} {
    upvar #0 class_frame f
    global	cb_showsyst
    global	cb_showuser
    global	cb_needuser
    global	db_connection

    cb_field_clear
    $f.f_list.list delete 0 end

    if {$cb_showsyst != 0 && $cb_showuser != 0} {
        set cb_needuser 1
    } else {
        set cb_needuser 0
    }

    if { [pqa_status $db_connection -version] == "V4.2"} {
	if {$cb_showsyst != 0} {
	    cb_busy
	    pqa_exec $db_connection		\
		"retrieve (pg_class.relname, pg_class.relkind) 
		    where pg_class.relname ~ \"^pg_\"
		      and pg_class.relkind != \"i\"
		    sort by relname" \
		-command {cb_class_dataready}
	    return
	}
	if {$cb_showuser != 0} {
	    cb_busy
	    pqa_exec $db_connection		\
		"retrieve (pg_class.relname, pg_class.relkind)
		    where pg_class.relname !~ \"^pg_\"
		      and pg_class.relkind != \"i\"
		    sort by relname" \
		-command {cb_class_dataready}
	    return
	}
    }
    if { [pqa_status $db_connection -version] == "V95"} {
	if {$cb_showsyst != 0} {
	    cb_busy
	    pqa_exec $db_connection		\
		"select relname, relkind from pg_class 
		    where pg_class.relname ~ \'^pg_\'
		      and pg_class.relkind <> \'i\'
		    order by relname" \
		-command {cb_class_dataready}
	    return
	}
	if {$cb_showuser != 0} {
	    cb_busy
	    pqa_exec $db_connection		\
		"select relname, relkind from pg_class
		    where pg_class.relname !~ \'^pg_\'
		      and pg_class.relkind <> \'i\'
		    order by relname" \
		-command {cb_class_dataready}
	    return
	}
    }
}


proc cb_class_dataready {result} {
    upvar #0 class_frame f
    global	cb_needuser
    global	db_connection

    if {[pqa_result $result -status] != "ok"} {
        return -code error [pqa_result $result -errormsg -clear]
    }

    pqa_loop $result value {
        $f.f_list.list insert end \
	    "[lindex $value 0] ([lindex $value 1])"
    }

    pqa_result $result -clear

    if {$cb_needuser != 0} {
        set cb_needuser 0
        if { [pqa_status $db_connection -version] == "V4.2"} {
	    pqa_exec $db_connection		\
		"retrieve (pg_class.relname, pg_class.relkind)
		    where pg_class.relname !~ \"^pg_\"
		      and pg_class.relkind != \"i\"
		    sort by relname" \
		-command {cb_class_dataready}
        }
        if { [pqa_status $db_connection -version] == "V95"} {
	    pqa_exec $db_connection		\
		"select relname, relkind from pg_class
		    where pg_class.relname !~ \'^pg_\'
		      and pg_class.relkind <> \'i\'
		    order by relname" \
		-command {cb_class_dataready}
        }
    } else {
        cb_ready
    }
}


proc cb_class_show {} {
    upvar #0 class_frame f

    set sel [$f.f_list.list curselection]
    if {$sel == ""} return

    cb_field_clear

    cb_field_show [lindex [$f.f_list.list get [lindex $sel 0]] 0]
}


