#
#
#


proc cb_field_setup {into} {
    global	field_frame

    set f $into.f_field
    set field_frame $f

    frame	$f -borderwidth 2 -relief sunken
    label	$f.lbl -text "Fields"				\
    		-anchor w -borderwidth 0 -relief flat
    frame	$f.f_list -borderwidth 0 -relief flat

    listbox	$f.f_list.fnames -width 16 -height 20		\
    		-borderwidth 1 -relief sunken			\
    		-yscrollcommand "$f.f_list.scrolly set"
    listbox	$f.f_list.ftypes -width 16 -height 20		\
    		-borderwidth 1 -relief sunken
    scrollbar	$f.f_list.scrolly -orient vertical		\
    		-width 11 -borderwidth 2 -relief sunken		\
    		-command "cd_field_yview yview"

    pack	$f.f_list.scrolly -side right -fill y		\
    		-padx 0 -pady 0
    pack	$f.f_list.fnames -side left -fill both		\
    		-expand true -padx 0 -pady 0
    pack	$f.f_list.ftypes -side left -fill both		\
    		-expand true -padx 0 -pady 0
    pack	$f.lbl -side top -fill x -padx 0 -pady 0
    pack	$f.f_list -side left -fill both -expand true	\
    		-padx 0 -pady 0

    return $f
}


proc cb_field_yview {args} {
    upvar #0 field_frame f

    eval $f.f_list.fnames yview $args
    eval $f.f_list.ftypes yview $args
}


proc cb_field_clear {} {
    upvar #0 field_frame f

    $f.f_list.fnames delete 0 end
    $f.f_list.ftypes delete 0 end
}


proc cb_field_show {class} {
    global	db_connection

    cb_busy
    if { [pqa_status $db_connection -version] == "V4.2"} {
	pqa_exec $db_connection \
	    "retrieve (a.attname, t.typname, a.attnum) from
		    c in pg_class,
		    a in pg_attribute,
		    t in pg_type
		    where c.relname = \"$class\"
		      and c.oid = a.attrelid
		      and a.attnum > 0
		      and t.oid = a.atttypid
		    sort by attnum"	\
	    -command cb_field_dataready
    }
    if { [pqa_status $db_connection -version] == "V95"} {
	pqa_exec $db_connection \
	    "select a.attname, t.typname, a.attnum from
		    pg_class c,
		    pg_attribute a,
		    pg_type t
		    where c.relname = \'$class\'
		      and c.oid = a.attrelid
		      and a.attnum > 0
		      and t.oid = a.atttypid
		    order by attnum"	\
	    -command cb_field_dataready
    }
}


proc cb_field_dataready {result} {
    upvar #0 field_frame f

    if {[pqa_result $result -status] != "ok"} {
        return -code error [pqa_result $result -errormsg -clear]
    }

    pqa_loop $result xxx {
        $f.f_list.fnames insert end [lindex $xxx 0]
        $f.f_list.ftypes insert end [lindex $xxx 1]
    }

    pqa_result $result -clear

    cb_ready
}


