#
#
#


proc cb_menu_setup {into} {
    global	menu_frame
    global	db_connection

    set f $into.f_menu
    set menu_frame $f

    set db_connection ""

    frame	$f -borderwidth 0 -relief flat
    menubutton	$f.database -text "Database" -width 10		\
    		-anchor w -borderwidth 0 -relief flat		\
    		-menu $f.database.menu
    menu	$f.database.menu
    $f.database.menu add command -label "Connect"		\
    		-state normal -command {cb_menu_connect}
    $f.database.menu add command -label "Disconnect"		\
    		-state disabled -command {cb_menu_disconnect}
    $f.database.menu add separator
    $f.database.menu add command -label "Quit"			\
    		-state normal -command {cb_menu_quit}

    pack	$f.database -side left -padx 0 -pady 0

    return $f
}


proc cb_menu_connect {} {
    upvar #0 menu_frame f
    upvar #0 button_frame bf
    global	tk_CBrowse_passwd

    upvar #0 cb_dbname	dbname
    upvar #0 cb_host	host
    upvar #0 cb_port	port
    upvar #0 cb_user	user
    upvar #0 cb_pass	pass
    upvar #0 cb_action	action

    global 	db_connection
    global	env

    toplevel	.dbconn
    frame	.dbconn.a
    frame	.dbconn.a.g
    frame	.dbconn.a.b
    label	.dbconn.a.g.lbl_db -text "Database:"		\
    		-anchor w -borderwidth 0 -relief flat
    label	.dbconn.a.g.lbl_host -text "DbHost:"		\
    		-anchor w -borderwidth 0 -relief flat
    label	.dbconn.a.g.lbl_port -text "DbPort:"		\
    		-anchor w -borderwidth 0 -relief flat
    label	.dbconn.a.g.lbl_user -text "Username:"		\
    		-anchor w -borderwidth 0 -relief flat
    label	.dbconn.a.g.lbl_pass -text "Password:"		\
    		-anchor w -borderwidth 0 -relief flat
    entry	.dbconn.a.g.ent_db -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable cb_dbname
    entry	.dbconn.a.g.ent_host -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable cb_host
    entry	.dbconn.a.g.ent_port -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable cb_port
    entry	.dbconn.a.g.ent_user -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable cb_user
    entry	.dbconn.a.g.ent_pass -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable cb_pass -show "*"

    button	.dbconn.a.b.conn -text "Connect"		\
    		-width 10 -borderwidth 2 -relief raised		\
    		-command {
    		    global	cb_action
    		    set		cb_action "connect"
    		    destroy	.dbconn
    		}
    button	.dbconn.a.b.cancel -text "Cancel"		\
    		-width 10 -borderwidth 2 -relief raised		\
    		-command {
    		    global	cb_action
    		    set		cb_action "cancel"
    		    destroy	.dbconn
    		}

    grid .dbconn.a.g.lbl_db -in .dbconn.a.g			\
    		-column 0 -row 0
    grid .dbconn.a.g.lbl_host -in .dbconn.a.g			\
    		-column 0 -row 1
    grid .dbconn.a.g.lbl_port -in .dbconn.a.g			\
    		-column 0 -row 2
    grid .dbconn.a.g.lbl_user -in .dbconn.a.g			\
    		-column 0 -row 3
    if {$tk_CBrowse_passwd} {
    grid .dbconn.a.g.lbl_pass -in .dbconn.a.g			\
    		-column 0 -row 5
    }
    grid .dbconn.a.g.ent_db -in .dbconn.a.g			\
    		-column 1 -row 0
    grid .dbconn.a.g.ent_host -in .dbconn.a.g			\
    		-column 1 -row 1
    grid .dbconn.a.g.ent_port -in .dbconn.a.g			\
    		-column 1 -row 2
    grid .dbconn.a.g.ent_user -in .dbconn.a.g			\
    		-column 1 -row 3
    if {$tk_CBrowse_passwd} {
    grid .dbconn.a.g.ent_pass -in .dbconn.a.g			\
    		-column 1 -row 5
    }
    pack .dbconn.a.b.conn -side left
    pack .dbconn.a.b.cancel -side left

    pack	.dbconn.a.g -side top
    pack	.dbconn.a.b -side top
    pack	.dbconn.a

    bind .dbconn.a.g.ent_db   <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.g.ent_host <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.g.ent_port <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.g.ent_user <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.g.ent_pass <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.b.conn     <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.b.cancel   <Key-Return> {.dbconn.a.b.cancel invoke}

    if {[info exists env(PGUSER)]} {
        set user $env(PGUSER)
	focus .dbconn.a.g.ent_pass
    } else {
        if {[info exists env(USER)]} {
            set user $env(USER)
	    focus .dbconn.a.g.ent_pass
        } else {
            set user ""
	    focus .dbconn.a.g.ent_user
        }
    }
    if {[info exists env(PGDATABASE)]} {
        set dbname $env(PGDATABASE)
    } else {
        set dbname $user
    }
    if {[info exists env(PGPORT)]} {
        set port $env(PGPORT)
    }
    if {[info exists env(PGHOST)]} {
        set host $env(PGHOST)
    } else {
        set host "localhost"
    }
    set pass ""
    set action "cancel"
    if {!$tk_CBrowse_passwd} {
	focus .dbconn.a.g.ent_db
    }

    wm transient .dbconn .
    set x [expr [winfo rootx .] + 100]
    set y [expr [winfo rooty .] + 20]
    wm geometry .dbconn +${x}+${y}

    $f.database.menu entryconfigure 1 -state disabled
    tkwait window .dbconn
    $f.database.menu entryconfigure 1 -state normal

    if {$action == "cancel"} {
	return
    }

    cb_busy

    if {$port != ""} {
	set conn [pqa_connect -host $host -dbname $dbname	\
    		-port $port -user $user]
    } else {
	set conn [pqa_connect -host $host -dbname $dbname	\
    		-user $user]
    }

    if {$tk_CBrowse_passwd && $pass != ""} {
    set res [pqa_exec $conn "login $user $pass"]
    if {[pqa_result $res -status] != "ok"} {
#        set msg [pqa_result $res -errormsg -clear]
#        catch {pqa_close $conn}
#        cd_ready
#        return -code error $msg
    }
    pqa_result $res -clear
    }

    set db_connection $conn

    cb_ready

    $f.database.menu entryconfigure 1 -state disabled
    $f.database.menu entryconfigure 2 -state normal
    $bf.sysclass configure -state normal
    $bf.usrclass configure -state normal
    $bf.reread configure -state normal

    update idletasks

    cb_class_update
}


proc cb_menu_disconnect {} {
    upvar #0 menu_frame f
    upvar #0 button_frame bf
    global	db_connection

    cb_class_clear
    cb_field_clear

    pqa_close $db_connection
    set db_connection ""

    $f.database.menu entryconfigure 1 -state normal
    $f.database.menu entryconfigure 2 -state disabled
    $bf.sysclass configure -state disabled
    $bf.usrclass configure -state disabled
    $bf.reread configure -state disabled
}


proc cb_menu_quit {} {
    upvar #0 menu_frame f
    global db_connection

    if {$db_connection != ""} {
        pqa_close $db_connection
    }

    destroy .
}


proc cb_busy {} {
    global menu_frame
    .all configure -cursor watch
    grab $menu_frame
    update idletasks
}

proc cb_ready {} {
    global menu_frame
    .all configure -cursor top_left_arrow
    grab release $menu_frame
}
