#
#
#


proc mo_menu_setup {into} {
    global	menu_frame
    global	db_connection

    set f $into.f_menu
    set menu_frame $f

    set db_connection ""

    frame	$f -borderwidth 0 -relief flat
    menubutton	$f.database -text "Database" -width 10		\
    		-anchor w -borderwidth 0 -relief flat		\
    		-menu $f.database.menu
    menu	$f.database.menu
    $f.database.menu add command -label "Connect"		\
    		-state normal -command {mo_menu_connect}
    $f.database.menu add command -label "Disconnect"		\
    		-state disabled -command {mo_menu_disconnect}
    $f.database.menu add separator
    $f.database.menu add command -label "Quit"			\
    		-state normal -command {mo_menu_quit}

    pack	$f.database -side left -padx 0 -pady 0

    bind $f <Control-Key-d> {mo_menu_disconnect}
    bind $f <Control-Key-q> {mo_menu_quit}

    return $f
}


proc mo_menu_settitle {title} {
    if {$title == ""} {
        wm title . "Postgres Monitor"
    } else {
        wm title . "Monitor: $title"
    }
}

proc mo_menu_connect {} {
    upvar #0 menu_frame f
    upvar #0 button_frame bf
    upvar #0 query_frame qf
    global tk_Monitor_passwd

    upvar #0 mo_dbname	dbname
    upvar #0 mo_host	host
    upvar #0 mo_port	port
    upvar #0 mo_user	user
    upvar #0 mo_pass	pass
    upvar #0 mo_action	action

    global 	db_connection
    global	env
    global	query_history
    global	query_hist_cur

    if {$db_connection != ""} {
        return
    }

    toplevel	.dbconn
    frame	.dbconn.a
    focus	.dbconn.a
    frame	.dbconn.a.g
    frame	.dbconn.a.b
    label	.dbconn.a.g.lbl_db -text "Database:"		\
    		-anchor w -borderwidth 0 -relief flat
    label	.dbconn.a.g.lbl_host -text "DbHost:"		\
    		-anchor w -borderwidth 0 -relief flat
    label	.dbconn.a.g.lbl_port -text "DbPort:"		\
    		-anchor w -borderwidth 0 -relief flat
    label	.dbconn.a.g.lbl_user -text "Username:"		\
    		-anchor w -borderwidth 0 -relief flat
    label	.dbconn.a.g.lbl_pass -text "Password:"		\
    		-anchor w -borderwidth 0 -relief flat
    entry	.dbconn.a.g.ent_db -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable mo_dbname
    entry	.dbconn.a.g.ent_host -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable mo_host
    entry	.dbconn.a.g.ent_port -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable mo_port
    entry	.dbconn.a.g.ent_user -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable mo_user
    entry	.dbconn.a.g.ent_pass -width 40 			\
    		-borderwidth 1 -relief sunken			\
    		-textvariable mo_pass -show "*"

    button	.dbconn.a.b.conn -text "Connect"		\
    		-width 10 -borderwidth 2 -relief raised		\
    		-command {
    		    global	mo_action
    		    set		mo_action "connect"
    		    destroy	.dbconn
    		}
    button	.dbconn.a.b.cancel -text "Cancel"		\
    		-width 10 -borderwidth 2 -relief raised		\
    		-command {
    		    global	mo_action
    		    set		mo_action "cancel"
    		    destroy	.dbconn
    		}

    grid .dbconn.a.g.lbl_db -in .dbconn.a.g			\
    		-column 0 -row 0
    grid .dbconn.a.g.lbl_host -in .dbconn.a.g			\
    		-column 0 -row 1
    grid .dbconn.a.g.lbl_port -in .dbconn.a.g			\
    		-column 0 -row 2
    grid .dbconn.a.g.lbl_user -in .dbconn.a.g			\
    		-column 0 -row 3
    if {$tk_Monitor_passwd} {
    grid .dbconn.a.g.lbl_pass -in .dbconn.a.g			\
    		-column 0 -row 5
    }
    grid .dbconn.a.g.ent_db -in .dbconn.a.g			\
    		-column 1 -row 0
    grid .dbconn.a.g.ent_host -in .dbconn.a.g			\
    		-column 1 -row 1
    grid .dbconn.a.g.ent_port -in .dbconn.a.g			\
    		-column 1 -row 2
    grid .dbconn.a.g.ent_user -in .dbconn.a.g			\
    		-column 1 -row 3
    if {$tk_Monitor_passwd} {
    grid .dbconn.a.g.ent_pass -in .dbconn.a.g			\
    		-column 1 -row 5
    }
    pack .dbconn.a.b.conn -side left
    pack .dbconn.a.b.cancel -side left

    pack	.dbconn.a.g -side top
    pack	.dbconn.a.b -side top
    pack	.dbconn.a

    bind .dbconn.a.g.ent_db   <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.g.ent_host <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.g.ent_port <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.g.ent_user <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.g.ent_pass <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.b.conn     <Key-Return> {.dbconn.a.b.conn invoke}
    bind .dbconn.a.b.cancel   <Key-Return> {.dbconn.a.b.cancel invoke}

    if {[info exists env(PGUSER)]} {
        set user $env(PGUSER)
	focus .dbconn.a.g.ent_pass
    } else {
        if {[info exists env(USER)]} {
            set user $env(USER)
	    focus .dbconn.a.g.ent_pass
        } else {
            set user ""
	    focus .dbconn.a.g.ent_user
        }
    }
    if {[info exists env(PGDATABASE)]} {
        set dbname $env(PGDATABASE)
    } else {
        set dbname $user
    }
    if {[info exists env(PGPORT)]} {
        set port $env(PGPORT)
    } else {
        set port ""
    }
    if {[info exists env(PGHOST)]} {
        set host $env(PGHOST)
    } else {
        set host "localhost"
    }
    set pass ""
    set action "cancel"
    if {!$tk_Monitor_passwd} {
	focus .dbconn.a.g.ent_db
    }

    wm transient .dbconn .
    set x [expr [winfo rootx .] + 100]
    set y [expr [winfo rooty .] + 20]
    wm geometry .dbconn +${x}+${y}

    $f.database.menu entryconfigure 1 -state disabled
    tkwait window .dbconn
    $f.database.menu entryconfigure 1 -state normal

    if {$action == "cancel"} {
	return
    }

    mo_busy

    if {$port != ""} {
	if {[catch {set conn [pqa_connect -host $host -dbname $dbname	\
    		-port $port -user $user]} errmsg]} {
            mo_apperr $errmsg
            mo_ready
            return
        }
    } else {
	if {[catch {set conn [pqa_connect -host $host -dbname $dbname	\
    		-user $user]} errmsg]} {
            mo_apperr $errmsg
            mo_ready
            return
        }
    }

    if {$tk_Monitor_passwd && $pass != ""} {
    set res [pqa_exec $conn "login $user $pass"]
    if {[pqa_result $res -status] != "ok"} {
        mo_apperr [pqa_result $res -errormsg]
    }
    pqa_result $res -clear
    }

    set db_connection $conn

    mo_appmsg "Connection to database established\n"
    mo_menu_settitle "$dbname@$host"

    mo_ready

    $f.database.menu entryconfigure 1 -state disabled
    $f.database.menu entryconfigure 2 -state normal

    catch {$bf.exec configure -state normal}
    if {[llength $query_history] > 0} {
        if {$query_hist_cur != 0} {
            catch {$bf.prev configure -state normal}
        }
        if {[llength $query_history] > $query_hist_cur} {
            catch {$bf.next configure -state normal}
        }
    }

    $qf.query configure -state normal
    focus $qf.query
}


proc mo_menu_disconnect {} {
    upvar #0 menu_frame f
    upvar #0 button_frame bf
    upvar #0 query_frame qf
    global	db_connection

    if {$db_connection == ""} {
        return
    }

    pqa_close $db_connection
    set db_connection ""

    mo_appmsg "Disconnected from database\n"
    mo_menu_settitle ""

    mo_ready

    $f.database.menu entryconfigure 1 -state normal
    $f.database.menu entryconfigure 2 -state disabled

    catch {$bf.exec configure -state disabled}
    catch {$bf.prev configure -state disabled}
    catch {$bf.next configure -state disabled}

    $qf.query configure -state disabled
}


proc mo_menu_quit {} {
    upvar #0 menu_frame f
    global db_connection

    if {$db_connection != ""} {
        pqa_close $db_connection
    }

    destroy .
}


proc mo_busy {} {
    global menu_frame
    global query_frame
    .all configure -cursor "watch red"
    $query_frame.query configure -cursor "watch red"
    $query_frame.f_msg.msg configure -cursor "watch red"
    grab $menu_frame
    focus $menu_frame
    update idletasks
}

proc mo_ready {} {
    global menu_frame
    global query_frame
    .all configure -cursor top_left_arrow
    $query_frame.query configure -cursor xterm
    $query_frame.f_msg.msg configure -cursor xterm
    grab release $menu_frame
    focus $query_frame.query
}
