#
#
#

proc mo_query_setup {into} {
    global	query_frame
    upvar #0	button_frame bf
    global	query_history
    global	query_hist_cur
    global	query_hist_tmp

    set f $into.f_query
    set query_frame $f
    set query_history ""
    set query_hist_cur 0
    set query_hist_tmp ""

    frame	$f -borderwidth 2 -relief sunken

    text	$f.query -borderwidth 0 -relief flat		\
    		-width 80 -height 10 -state disabled		\
    		-font fixed

    frame	$f.f_msg -borderwidth 0 -relief flat
    text	$f.f_msg.msg -borderwidth 1 -relief sunken	\
    		-height 5 -font fixed -state disabled		\
    		-yscrollcommand "$f.f_msg.scrolly set"
    scrollbar	$f.f_msg.scrolly -orient vertical		\
    		-width 9 -borderwidth 2 -relief sunken		\
    		-command "$f.f_msg.msg yview"
    
    pack	$f.f_msg.scrolly -side right -fill y		\
    		-padx 0 -pady 0
    pack	$f.f_msg.msg -side left -fill x -expand true	\
    		-padx 0 -pady 0
    pack	$f.f_msg -side bottom -fill x -padx 0 -pady 0
    pack	$f.query -side top -fill both -padx 0 -pady 0	\
    		-expand true

    focus	$f.query

    bind	$f.query <Shift-Key-Return> mo_query_exec
    bind	$f.query <Control-Key-Return> mo_query_exec
    bind	$f.query <Key-Prior> mo_query_prev
    bind	$f.query <Key-Next> mo_query_next
    bind	$f.query <Mod1-Key> "+$f.query insert insert \"%A\""
    bind	$f.query <Control-Key-q> mo_menu_quit
    bind	$f.query <Control-Key-d> mo_menu_disconnect
    bind	$f.query <Shift-Key-Prior> {
    		    global result_frame
    		    $result_frame.res yview scroll -1 pages
    		}
    bind	$f.query <Shift-Key-Next> {
    		    global result_frame
    		    $result_frame.res yview scroll 1 pages
    		}
    bind	$f.query <Shift-Key-Up> {
    		    global result_frame
    		    $result_frame.res yview scroll -5 units
    		}
    bind	$f.query <Shift-Key-Down> {
    		    global result_frame
    		    $result_frame.res yview scroll 5 units
    		}
    bind	$f.query <Shift-Key-Left> {
    		    global result_frame
    		    $result_frame.res xview scroll -5 units
    		    $result_frame.att xview scroll -5 units
    		}
    bind	$f.query <Shift-Key-Right> {
    		    global result_frame
    		    $result_frame.res xview scroll 5 units
    		    $result_frame.att xview scroll 5 units
    		}

    return $f
}


proc mo_query_bexec {} {
    upvar #0	query_frame f

    mo_query_exec
}

proc mo_query_exec {} {
    upvar #0	query_frame f
    global	db_connection

    if {[$f.query get "insert - 1 chars"] == "\n"} {
	$f.query delete "insert - 1 chars"
    }

    set query [string trim [$f.query get 1.0 end]]
    $f.query delete 1.0 end
    $f.query insert insert $query
    if {$query == ""} {
        set query " "
    }

    mo_busy

    regsub -all "\n" $query " " pq_query
    pqa_exec $db_connection $pq_query -command mo_query_result
}


proc mo_query_result {res} {
    upvar #0	query_frame f
    upvar #0	button_frame bf
    global	query_history
    global	query_hist_cur
    global	query_hist_tmp

    if {[pqa_result $res -status] != "ok"} {
	mo_seterr [pqa_result $res -errormsg -clear]
        mo_ready
        return
    }

    mo_setmsg [pqa_result $res -cmdreturn]
    if {[pqa_result $res -errormsg] != ""} {
        mo_apperr [pqa_result $res -errormsg]
    }

    set query [string trim [$f.query get 1.0 end]]
    if {$query != ""} {
	if {[llength $query_history] >= 40} {
	    set query_history [lrange $query_history 1 end]
	}
	lappend query_history $query
	set query_hist_cur [llength $query_history]
	set query_hist_tmp ""
	catch {$bf.prev configure -state normal}
	catch {$bf.next configure -state disabled}
    }

    if {[pqa_result $res -attributes] != ""} {
        mo_result_dumpdata $res
    }

    $f.query delete "1.0" end
    pqa_result $res -clear
    mo_ready
}


proc mo_query_prev {} {
    upvar #0	query_frame f
    upvar #0	button_frame bf
    global	query_history
    global	query_hist_cur
    global	query_hist_tmp

    if {$query_hist_cur == 0} return

    if {[llength $query_history] == $query_hist_cur} {
        set query_hist_tmp [$f.query get 1.0 end]
    }
    set query_hist_cur [expr $query_hist_cur - 1]
    $f.query delete 1.0 end
    $f.query insert insert [string trim [lindex $query_history $query_hist_cur]]
    if {$query_hist_cur == 0} {
        catch {$bf.prev configure -state disabled}
    }
    catch {$bf.next configure -state normal}
}


proc mo_query_next {} {
    upvar #0	query_frame f
    upvar #0	button_frame bf
    global	query_history
    global	query_hist_cur
    global	query_hist_tmp

    if {$query_hist_cur == [llength $query_history]} return

    incr query_hist_cur
    $f.query delete 1.0 end
    if {[llength $query_history] <= $query_hist_cur} {
        $f.query insert insert [string trim $query_hist_tmp]
        catch {$bf.next configure -state disabled}
    } else {
        $f.query insert insert [string trim [lindex $query_history $query_hist_cur]]
    }
    catch {$bf.prev configure -state normal}
}


proc mo_setmsg {msg} {
    upvar #0	query_frame f

    $f.f_msg.msg configure -state normal
    $f.f_msg.msg delete 1.0 end

    if {$msg == ""} {
	$f.f_msg.msg configure -state disabled
	return
    }

    $f.f_msg.msg insert insert [string trim $msg]
    $f.f_msg.msg see end
    $f.f_msg.msg configure -state disabled
}


proc mo_seterr {msg} {
    upvar #0	query_frame f

    $f.f_msg.msg configure -state normal
    $f.f_msg.msg delete 1.0 end

    if {$msg == ""} {
	$f.f_msg.msg configure -state disabled
	return
    }

    $f.f_msg.msg insert insert [string trim $msg] msg
    $f.f_msg.msg tag configure msg -foreground red
    $f.f_msg.msg see end
    $f.f_msg.msg configure -state disabled
}


proc mo_appmsg {msg} {
    upvar #0	query_frame f

    $f.f_msg.msg configure -state normal

    if {$msg == ""} {
	$f.f_msg.msg configure -state disabled
    }

    $f.f_msg.msg insert end "\n[string trim $msg]"
    $f.f_msg.msg see end
    $f.f_msg.msg configure -state disabled
}


proc mo_apperr {msg} {
    upvar #0	query_frame f

    $f.f_msg.msg configure -state normal

    if {$msg == ""} {
	$f.f_msg.msg configure -state disabled
    }

    $f.f_msg.msg insert end "\n[string trim $msg]" msg
    $f.f_msg.msg tag configure msg -foreground red
    $f.f_msg.msg see end
    $f.f_msg.msg configure -state disabled
}


