#
#
#


proc mo_result_setup {into} {
    global	result_frame

    set f $into.f_result
    set result_frame $f

    frame	$f -borderwidth 2 -relief sunken

    canvas	$f.att -borderwidth 0 -relief flat		\
    		-width 100 -height 1				\
    		-highlightthickness 0
    frame	$f.att.grid -borderwidth 0 -relief flat
    label	$f.att.grid.dummy -borderwidth 0 -relief flat	\
    		-text " " -font fixed
    canvas	$f.res -borderwidth 0 -relief flat		\
    		-width 100 -height 300				\
    		-yscrollcommand "$f.scrolly set"		\
    		-xscrollcommand "$f.scrollx set"		\
    		-highlightthickness 0
    scrollbar	$f.scrolly -orient vertical			\
    		-width 9 -borderwidth 2 -relief sunken		\
    		-command "$f.res yview"
    scrollbar	$f.scrollx -orient horizontal			\
    		-width 9 -borderwidth 2 -relief sunken		\
    		-command "mo_result_xview"

    pack	$f.scrolly -side right -fill y			\
    		-padx 0 -pady 0
    pack	$f.scrollx -side bottom -fill x			\
    		-padx 0 -pady 0

    grid	$f.att.grid.dummy -in $f.att.grid		\
    		-padx 1 -pady 2
    pack $f.att.grid -padx 1 -pady 0

    pack	$f.att -side top -fill x			\
    		-padx 0 -pady 0 -expand false
    pack	$f.res -side top -fill both			\
    		-padx 0 -pady 0 -expand true

    return $f
}


proc mo_result_xview {args} {
    upvar #0	result_frame	f

    eval $f.att xview $args
    eval $f.res xview $args
}


proc mo_result_dumpdata {res} {
    upvar #0	result_frame	f

    set attributes [pqa_result $res -attributes]

    destroy $f.att.grid
    $f.res delete d
    mo_appmsg "Got [pqa_result $res -numtuples] with [	\
    	llength $attributes] attributes\n"
    update

    frame $f.att.grid -borderwidth 0 -relief flat -background navy
    $f.att	create window 0 0 -window $f.att.grid -anchor nw

    $f.att xview moveto 0.0
    $f.res xview moveto 0.0
    $f.res yview moveto 0.0

    set i 0;
    foreach alist $attributes {
        set colwid($i) [string length [lindex $alist 0]]
        incr i
    }
    set r 0
    pqa_loop $res record {
        set c 0
        set rowht($r) 1
        foreach val $record {
	    set vl [split $val "\n"]
	    foreach v $vl {
		regsub -all "	" $v "        " v
		set cw [string length $v]
		if {$colwid($c) < $cw} {
		    set colwid($c) $cw
		}
	    }
	    set ht [llength $vl]
	    if {$rowht($r) < $ht} {
	        set rowht($r) $ht
	    }
            incr c
        }
        incr r
        if {$r % 40 == 0} {
            update
        }
    }

    set i 0;
    foreach alist $attributes {
        set att [lindex $alist 0]

        label	$f.att.grid.c$i -borderwidth 0 -relief flat	\
		-text $att -width $colwid($i) -anchor c 	\
		-font fixed -foreground navy
        grid	$f.att.grid.c$i -in $f.att.grid			\
        	-column $i -row 0 -padx 1 -pady 1
        incr i
    }

    update
    set awid [winfo width  $f.att.grid]
    set aht  [winfo height $f.att.grid]
    $f.att configure -height $aht	\
    	-scrollregion "0 0 $awid $aht"
    update

    set x 0
    for {set c 0} {$c < $i} {incr c} {
        set colx($c) $x
        set colw($c) [winfo width $f.att.grid.c$c]
        set colx2($c) [expr $x + $colw($c) + 1]
        set colxt($c) [expr $x + 2]
        set x [expr $x + $colw($c) + 2]
    }
    set rowh [expr [winfo height $f.att.grid.c0] + 0]

    set r 0
    set y 0
    pqa_loop $res record {
        set c 0
        set y2 [expr $y + $rowht($r) * $rowh]
        set yt [expr ($y + $y2) >> 1]
        foreach val $record {
	    if {[catch {set {} [expr double($val)]}] == 0} {
		set val [format "%*s" $colwid($c) $val]
	    }
	    $f.res create rectangle 				\
	        $colx($c) $y $colx2($c) $y2			\
	        -outline black -tags d
	    $f.res create text $colxt($c) $yt			\
	    	-text $val -font fixed -anchor w -tags d
            incr c
        }
        incr r
        set y $y2
        if {$r % 40 == 0} {
	    set rht  [expr $rowh * $r]
	    $f.res configure -scrollregion "0 0 $awid $rht"	\
		-yscrollincrement $rowh
            update idletasks
        }
    }

    update

    incr y
    $f.res configure -scrollregion "0 0 $awid $y"		\
    	-yscrollincrement $rowh
}
