#!/usr/bin/tclsh7.5

package require Sqlpqa

#---------------------------------------------------------------------
# First create the test database
#---------------------------------------------------------------------
set tdb [SQLconnect -dbname template1 -port 5432]
$tdb create database testdb_1
SQLdisconnect $tdb


#---------------------------------------------------------------------
# Now connect to the test database
#---------------------------------------------------------------------
set db [SQLconnect -dbname testdb_1 -port 5432]

#---------------------------------------------------------------------
# Create the tables
#---------------------------------------------------------------------
$db create table usr (		\
	login	char16,		\
	uid	int4,		\
	realname text)

$db create table sys (sysname char16, ipaddr char16)
$db create table adm (sysname char16, login char16)

#---------------------------------------------------------------------
# Load the test data
#---------------------------------------------------------------------
$db begin

$db insert into usr values ('wieck', 100, 'Jan Wieck')
$db insert into usr values ('guest', 101, 'Guest account')
$db insert into usr values ('jones', 102, 'Tom Jones')

$db insert into sys values ('orion', '53.2.130.192')
$db insert into sys values ('mars', '53.2.130.17')
$db insert into sys values ('jupiter', '53.2.130.16')

$db insert into adm values ('orion', 'wieck')
$db insert into adm values ('mars', 'wieck')
$db insert into adm values ('jupiter', 'wieck')
$db insert into adm values ('mars', 'jones')

$db commit

#---------------------------------------------------------------------
# Now use that in some queries
#---------------------------------------------------------------------

$db begin

puts [format "%-20.20s %-16.16s" System IP-Addr]
puts [format "%-20.20s %-16.16s" -------------------- ----------------]

$db select * from sys 	\
	order by sysname {
    puts [format "%-20.20s %-16.16s" $sysname $ipaddr]
}

puts ""

#---------------------------------------------------------------------

puts [format "%-20.20s %-16.16s" System Admin(s)]
puts [format "%-20.20s %-16.16s" -------------------- ----------------]

$db select sysname as system_name from sys	\
	order by system_name {
    set admlist ""
    $db select U.login, U.realname	\
    	    from usr U, adm A		\
	    where A.sysname = '$system_name' and U.login = A.login \
	    order by login {
        if {$admlist != ""} {
	    append admlist ", "
	}
	append admlist "$login ($realname)"
    }
    puts [format "%-20.20s %s" $system_name $admlist]
}

puts ""

#---------------------------------------------------------------------

puts [format "%-15.15s %-20.20s" User "Admin for system"]
puts [format "%-15.15s %-20.20s" --------------- --------------------]

$db select login from usr order by login {
    set syslist ""
    $db select sysname from adm		\
    	    where login = '$login'	\
	    order by sysname {

	#-----------------------------------------------------------
	# SQL enhancement with 'single' keyword - this select
	# statement doesn't loop!!!
	#-----------------------------------------------------------
        $db select single ipaddr from sys	\
	    where sysname = '$sysname'

        if {$syslist != ""} {
	    append syslist ", "
	}
	append syslist "$sysname \[$ipaddr\]"
    }
    puts [format "%-15.15s %s" $login $syslist]
}
$db select single * from usr where login = '$login'
puts "The last user was $login UID=$uid ($realname)"

puts ""

$db commit

#---------------------------------------------------------------------
# Finally close the testdatabase and destroy it
#---------------------------------------------------------------------
SQLdisconnect $db
set tdb [SQLconnect -dbname template1 -port 5432]
$tdb drop database testdb_1
SQLdisconnect $tdb
