# ==========================================
# The package we want to load.

package require dom

# ==========================================

set     information [list]
lappend information {}
lappend information {The wrap is successful if the resulting executable is able to load}
lappend information {the package "dom::libxml2" (which is the library file "Tcldomxml").}
lappend information {If this package/file is not listed below then DOM has been wrapped,}
lappend information {is useable too, but uses an implementation written in Tcl, and is}
lappend information {therefore slow compared to an application which actually uses the}
lappend information {C implementation in "libxml2".}
lappend information {}
lappend information {}
lappend information {Loaded packages (DOM only)}

set ok 0

catch {package require __bad__}
foreach p [lsort [package names]] {
    if {![string match dom* $p]} continue
    if {[catch {set v [package present $p]}]} continue

    if {[string match *libxml2 $p]} {
	set prefix "SUCCESS"
	set ok 1
    } else {
	set prefix "       "
    }
    catch {lappend information "*\t$prefix $p\t$v"}
}

lappend information {}
lappend information {Loaded libraries (DOM only)}
foreach lib [lsort [info loaded]] {
    foreach {path id} $lib break
    if {![string match *dom* $id]} continue
    if {[string match *domxml* $id]} {
	set prefix "SUCCESS"
	set ok 1
    } else {
	set prefix "       "
    }
    lappend information "*\t$prefix $id\n\t\t($path)"
}

if {!$ok} {
    lappend information {}
    lappend information {FAILURE.}
    lappend information {The C implementation of TclDOM is not loaded.}
}



package require Tk

wm title . Information

switch -exact [tk windowingsystem] {
    "x11" {
	set size	-12
	set family	Helvetica
	set fsize	-12
	set ffamily	Courier
    }
    "win32" {
	set size	8
	set family	Tahoma
	set fsize	9
	set ffamily	Courier
    }
    "aqua" - "macintosh" {
	set size	11
	set family	"Lucida Grande"
	set size	11
	set family	Courier
    }
}
font create ASfontFixed -size $fsize -family $ffamily
option add *Text.font		ASfontFixed widgetDefault

text   .t -relief sunken -width 100 -height 50
button .e -command exit -text Ok

.t insert end [join $information \n]

pack   .t
pack   .e -pady 1m

vwait __forever__
exit

