set dirname [file dirname [file normalize [info script]]]
lappend auto_path [file join $dirname lib stomp]

set bin_fname \
    [file join $dirname .. .. me3gas cxManager pics contextmanager.ico]
set fd [open $bin_fname]
fconfigure $fd -translation binary -encoding binary
set dta [read $fd]
close $fd

puts "Will send a binary blob of size: [string length $dta]"

package require stomp::client

proc received { cid rid } {
    puts "Server has received message, id: $rid"
}
 
proc incoming { msg } {
    global dta
    puts "Incoming message: [::stomp::message::getCommand $msg]"
    set type [::stomp::message::getHeader $msg content-type]
    if { $type eq "image/x-icon" } {
	puts "Comparing: [string eq $dta [::stomp::message::getBody $msg]]"
    }
}

proc stop {} {
    global s

    set sub [lindex [::stomp::client::subscriptions $s /queue/a] 0]
    ::stomp::client::unsubscribe $sub
}


set s [::stomp::client::connect -user admin -password password]
set ops [list \
	     1000 [list ::stomp::client::subscribe $s /queue/a \
		       -handler incoming] \
	     2000 [list ::stomp::client::send $s /queue/a -body "Hello world" \
		       -receipt received] \
	     4000 [list ::stomp::client::send $s /queue/a \
		       -type image/x-icon \
		       -body $dta] \
	     6000 stop \
	     7000 [list ::stomp::client::send $s /queue/a -body "Gone away?"] \
	     30000 [list ::stomp::client::disconnect $s] \
	     ]
	 
foreach { when what } $ops {
    after $when $what
}
vwait forever
