set dirname [file dirname [file normalize [info script]]]

set bin_fname \
    [file join $dirname .. .. me3gas cxManager pics contextmanager.ico]
set fd [open $bin_fname]
fconfigure $fd -translation binary -encoding binary
set dta [read $fd]
close $fd

puts "Sees a binary blob of size: [string length $dta]"

proc GetOpt {_argv name {_var ""} {default ""}} {
    upvar 1 $_argv argv $_var var
    set pos [lsearch -regexp $argv ^$name]
    if {$pos>=0} {
	set to $pos
	if {$_var ne ""} {
	    set var [lindex $argv [incr to]]
	}
	set argv [lreplace $argv $pos $to]
	return 1
    } else {
	if {[llength [info level 0]] == 5} {set var $default}
	return 0
    }
}


proc optionReceiver { noop {args {}}} {
    set body "";
    GetOpt args -body body $body

    puts "Received a binary blob of [string length $body]"
}

after idle [list optionReceiver ofNoInterest -body $dta]

vwait forever
