# Unix chapter
proc makedir { pathname } {
	if {[file isdirectory $pathname]} {
		return $pathname
	} elseif {[file exists $pathname]} {
		error "Non-directory $pathname already exists."
	} else {
		# Recurse to create intermediate directories
		makedir [file dirname $pathname]
		exec mkdir $pathname
		return $pathname
	}
}
