/* main.c */
#include <tcl.h>

/*
 * Declarations for application-specific command procedures
 */
int RandomCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
int Tcl_AppInit(Tcl_Interp *interp);

main(int argc, char *argv[]) {
	Tcl_Main(argc, argv, Tcl_AppInit);
	exit(0);
}
/*
 * Tcl_AppInit is called from Tcl_Main
 * after the Tcl interpreter has been created,
 * and before the script file
 * or interactive command loop is entered.
 */
int
Tcl_AppInit(Tcl_Interp *interp) {
	/*
	 * Initialize packages
	 * Tcl_Init sets up the Tcl library facility.
	 */
	if (Tcl_Init(interp) == TCL_ERROR) {
		return TCL_ERROR;
	}
	/*
	 * Register application-specific commands.
	 */
	Tcl_CreateCommand(interp, "random", RandomCmd,
			(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	/*
	 * Define startup filename. This file is read in
	 * case the program is run interactively.
	 */
	tcl_RcFileName = "~/.myapp.tcl";
	/*
	 * Test of Tcl_Invoke.
	 */
	Tcl_Invoke(interp, "set", "foo", "$xyz [foo] {", NULL);
	return TCL_OK;
}
