'\"
'\" Copyright (c) 1998-2000 by Scriptics Corporation.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: queue.n,v 1.1.1.1 2000/02/24 17:44:43 ericm Exp $
'\" 
.so man.macros
.TH queue n 8.3 Struct "Tcl Data Structures"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::struct::queue \- Create and manipulate queue objects
.SH SYNOPSIS
\fBpackage require struct ?1.0?\fR
.sp
\fB::struct::queue\fR \fIqueueName\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fB::struct::queue\fR command creates a new queue object with an
associated global Tcl command whose name is \fIqueueName\fR.  This command
may be used to invoke various operations on the queue.  It has the
following general form:
.CS
\fIqueueName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for queue objects:
.TP
\fIqueueName \fBclear\fR
Remove all items from the queue.
.TP
\fIqueueName \fBdestroy\fR
Destroy the queue, including its storage space and associated command.
.TP
\fIqueueName \fBget\fR ?\fIcount\fR?
Return the front \fIcount\fR items of the queue and remove them
from the queue.  If \fIcount\fR is not specified, it defaults to 1.
If \fIcount\fR is 1, the result is a simple string; otherwise, it is a list.
If specified, \fIcount\fR must be greater than or equal to 1.  If
there are no items in the queue, this command will return \fIcount\fR
empty strings.
.TP
\fIqueueName \fBpeek\fR ?\fIcount\fR?
Return the front \fIcount\fR items of the queue, without removing them
from the queue.  If \fIcount\fR is not specified, it defaults to 1.
If \fIcount\fR is 1, the result is a simple string; otherwise, it is a list.
If specified, \fIcount\fR must be greater than or equal to 1.  If
there are no items in the queue, this command will return \fIcount\fR
empty strings.
.TP
\fIqueueName \fBput\fR \fIitem\fR ?\fIitem ...\fR?
Put the item or items specified into the queue.  If more than one
item is given, they will be added in the order they are listed.
.TP
\fIqueueName \fBsize\fR
Return the number of items in the queue.

.SH KEYWORDS
stack, queue
