/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;

class Parser {
    static final char TYPE_NORMAL = '\u0000';
    static final char TYPE_SPACE = '\u0001';
    static final char TYPE_COMMAND_END = '\u0002';
    static final char TYPE_SUBS = '\u0004';
    static final char TYPE_QUOTE = '\b';
    static final char TYPE_CLOSE_PAREN = '\u0010';
    static final char TYPE_CLOSE_BRACK = ' ';
    static final char TYPE_BRACE = '@';
    static final char TYPE_MAX = '\u007f';
    static char[] typeTable = new char[]{'\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\b', '\u0000', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0010', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0004', '\u0004', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '@', '\u0000', '@', '\u0000', '\u0000'};
    static final int TCL_TOKEN_WORD = 1;
    static final int TCL_TOKEN_SIMPLE_WORD = 2;
    static final int TCL_TOKEN_TEXT = 4;
    static final int TCL_TOKEN_BS = 8;
    static final int TCL_TOKEN_COMMAND = 16;
    static final int TCL_TOKEN_VARIABLE = 32;
    static final int TCL_NO_EVAL = 65536;
    static final int TCL_EVAL_GLOBAL = 131072;
    static final int TCL_EVAL_DIRECT = 262144;
    static final int TCL_BRACKET_TERM = 1;
    static final int TCL_ALLOW_EXCEPTIONS = 4;
    static final int DELETED = 1;
    static final int ERR_IN_PROGRESS = 2;
    static final int ERR_ALREADY_LOGGED = 4;
    static final int ERROR_CODE_SET = 8;
    static final int EXPR_INITIALIZED = 16;
    static final int DONT_COMPILE_CMDS_INLINE = 32;
    static final int RAND_SEED_INITIALIZED = 64;
    static final int SAFE_INTERP = 128;
    static final int USE_EVAL_DIRECT = 256;
    private static final int OBJV_CACHE_MAX = 10;
    private static final int[] OBJV_CACHE_SIZES = new int[]{0, 4, 4, 10, 4, 4, 4, 4, 4, 4};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TclParse parseCommand(Interp interp, char[] script_array, int script_index, int numBytes, String fileName, int lineNum, boolean nested) {
        TclParse parse;
        char savedChar;
        block49: {
            char type;
            BackSlashResult bs;
            char cur;
            int endIndex;
            int saved_script_index = script_index;
            int script_length = script_array.length - 1;
            if (numBytes < 0) {
                numBytes = script_length - script_index;
            }
            if ((endIndex = script_index + numBytes) > script_length) {
                endIndex = script_length;
            }
            savedChar = script_array[endIndex];
            script_array[endIndex] = '\u0000';
            parse = new TclParse(interp, script_array, endIndex, fileName, lineNum);
            int terminators = nested ? 34 : 2;
            try {
                block2: while (true) {
                    cur = script_array[script_index];
                    while (true) {
                        if ((cur > '\u007f' || typeTable[cur] != '\u0001') && cur != '\n') {
                            if (cur != '\\' || script_array[script_index + 1] != '\n') break;
                            if (script_index + 2 == parse.endIndex) {
                                parse.incomplete = true;
                            }
                            script_index += 2;
                            continue block2;
                        }
                        cur = script_array[++script_index];
                    }
                    if (cur != '#') {
                        parse.commandStart = script_index;
                        break;
                    }
                    if (parse.commentStart < 0) {
                        parse.commentStart = script_index;
                    }
                    while (true) {
                        cur = script_array[script_index];
                        if (script_index == parse.endIndex) {
                            parse.incomplete = true;
                            parse.commentSize = script_index - parse.commentStart;
                            continue block2;
                        }
                        if (cur == '\\') {
                            if (script_array[script_index + 1] == '\n' && script_index + 2 == parse.endIndex) {
                                parse.incomplete = true;
                            }
                            bs = Parser.backslash(script_array, script_index);
                            script_index = bs.nextIndex;
                            continue;
                        }
                        if (cur == '\n') {
                            parse.commentSize = ++script_index - parse.commentStart;
                            continue block2;
                        }
                        ++script_index;
                    }
                    break;
                }
            }
            catch (TclException e) {
                script_array[endIndex] = savedChar;
                if (parse.commandStart < 0) {
                    parse.commandStart = saved_script_index;
                }
                parse.commandSize = parse.termIndex - parse.commandStart;
                parse.result = 1;
                return parse;
            }
            while (true) {
                TclToken token;
                int wordIndex;
                block52: {
                    block54: {
                        block50: {
                            block53: {
                                block51: {
                                    wordIndex = parse.numTokens;
                                    token = parse.getToken(wordIndex);
                                    token.type = 1;
                                    while (true) {
                                        char c = type = (cur = script_array[script_index]) > '\u007f' ? (char)'\u0000' : typeTable[cur];
                                        if (type == '\u0001') {
                                            ++script_index;
                                            continue;
                                        }
                                        if (cur != '\\' || script_array[script_index + 1] != '\n') break;
                                        if (script_index + 2 == parse.endIndex) {
                                            parse.incomplete = true;
                                        }
                                        bs = Parser.backslash(script_array, script_index);
                                        script_index = bs.nextIndex;
                                    }
                                    if ((type & terminators) != 0) {
                                        ++script_index;
                                        break block49;
                                    }
                                    if (script_index == parse.endIndex) break block49;
                                    token.script_array = script_array;
                                    token.script_index = script_index;
                                    ++parse.numTokens;
                                    ++parse.numWords;
                                    cur = script_array[script_index];
                                    if (cur != '\"') break block51;
                                    parse = Parser.parseTokens(script_array, ++script_index, 8, parse);
                                    if (parse.result != 0) {
                                        throw new TclException(parse.result);
                                    }
                                    if (parse.string[parse.termIndex] != '\"') {
                                        parse.termIndex = script_index - 1;
                                        parse.incomplete = true;
                                        throw new TclException(parse.interp, "missing \"");
                                    }
                                    script_index = parse.termIndex + 1;
                                    break block52;
                                }
                                if (cur == '{') break block53;
                                parse = Parser.parseTokens(script_array, script_index, 1 | terminators, parse);
                                if (parse.result != 0) {
                                    throw new TclException(parse.result);
                                }
                                script_index = parse.termIndex;
                                break block52;
                            }
                            token = parse.getToken(parse.numTokens);
                            token.type = 4;
                            token.script_array = script_array;
                            token.script_index = ++script_index;
                            token.numComponents = 0;
                            int level = 1;
                            while (true) {
                                cur = script_array[script_index];
                                while ((cur > '\u007f' ? (char)'\u0000' : typeTable[cur]) == '\u0000') {
                                    cur = script_array[++script_index];
                                }
                                if (script_array[script_index] == '}') {
                                    if (--level == 0) {
                                        if (script_index == token.script_index) {
                                            break;
                                        }
                                        break block50;
                                    } else {
                                        ++script_index;
                                        continue;
                                    }
                                }
                                if (script_array[script_index] == '{') {
                                    ++level;
                                    ++script_index;
                                    continue;
                                }
                                if (script_array[script_index] == '\\') {
                                    bs = Parser.backslash(script_array, script_index);
                                    if (script_array[script_index + 1] == '\n') {
                                        if (script_index + 2 == parse.endIndex) {
                                            parse.incomplete = true;
                                        }
                                        token.size = script_index - token.script_index;
                                        if (token.size != 0) {
                                            ++parse.numTokens;
                                        }
                                        token = parse.getToken(parse.numTokens);
                                        token.type = 8;
                                        token.script_array = script_array;
                                        token.script_index = script_index;
                                        token.size = bs.nextIndex - script_index;
                                        token.numComponents = 0;
                                        ++parse.numTokens;
                                        script_index = bs.nextIndex;
                                        token = parse.getToken(parse.numTokens);
                                        token.type = 4;
                                        token.script_array = script_array;
                                        token.script_index = script_index;
                                        token.numComponents = 0;
                                        continue;
                                    }
                                    script_index = bs.nextIndex;
                                    continue;
                                }
                                if (script_index == parse.endIndex) {
                                    parse.termIndex = parse.getToken((int)wordIndex).script_index;
                                    parse.incomplete = true;
                                    throw new TclException(interp, "missing close-brace");
                                }
                                ++script_index;
                            }
                            if (parse.numTokens != wordIndex + 1) break block54;
                        }
                        token.size = script_index - token.script_index;
                        ++parse.numTokens;
                    }
                    ++script_index;
                }
                token = parse.getToken(wordIndex);
                token.size = script_index - token.script_index;
                token.numComponents = parse.numTokens - (wordIndex + 1);
                if (token.numComponents == 1 && parse.getToken((int)(wordIndex + 1)).type == 4) {
                    token.type = 2;
                }
                char c = type = (cur = script_array[script_index]) > '\u007f' ? (char)'\u0000' : typeTable[cur];
                if (type == '\u0001') {
                    ++script_index;
                    continue;
                }
                if (cur != '\\' || script_array[script_index + 1] != '\n') break;
                if (script_index + 2 == parse.endIndex) {
                    parse.incomplete = true;
                }
                bs = Parser.backslash(script_array, script_index);
                script_index = bs.nextIndex;
            }
            if ((type & terminators) != 0) {
                ++script_index;
            } else if (script_index != parse.endIndex) {
                parse.termIndex = script_index;
                if (script_array[script_index - 1] == '\"') {
                    throw new TclException(interp, "extra characters after close-quote");
                }
                throw new TclException(interp, "extra characters after close-brace");
            }
        }
        script_array[endIndex] = savedChar;
        parse.commandSize = script_index - parse.commandStart;
        parse.result = 0;
        return parse;
    }

    /*
     * WARNING - void declaration
     */
    static TclParse parseTokens(char[] script_array, int script_index, int mask, TclParse parse) {
        void var3_3;
        int originalTokens;
        block16: {
            boolean debug = false;
            originalTokens = parse.numTokens;
            while (true) {
                char type;
                TclToken token = parse.getToken(parse.numTokens);
                token.script_array = script_array;
                token.script_index = ++script_index;
                token.numComponents = 0;
                char cur = script_array[script_index];
                char c = type = cur > '\u007f' ? (char)'\u0000' : typeTable[cur];
                if ((type & mask) != 0) break block16;
                if ((type & 4) == 0) {
                    while (((type = (cur = script_array[++script_index]) > '\u007f' ? (char)'\u0000' : typeTable[cur]) & (mask | 4)) == 0) {
                    }
                    token.type = 4;
                    token.size = script_index - token.script_index;
                    ++parse.numTokens;
                    continue;
                }
                if (cur == '$') {
                    int varToken = parse.numTokens;
                    parse = Parser.parseVarName(parse.interp, script_array, script_index, parse.endIndex - script_index, parse, true);
                    if (parse.result != 0) {
                        return parse;
                    }
                    script_index += parse.getToken((int)varToken).size;
                    continue;
                }
                if (cur == '[') {
                    block17: {
                        ++script_index;
                        do {
                            TclParse nested = Parser.parseCommand(parse.interp, script_array, script_index, parse.endIndex - script_index, parse.fileName, parse.lineNum, true);
                            if (nested.result != 0) {
                                parse.termIndex = nested.termIndex;
                                parse.incomplete = nested.incomplete;
                                parse.result = nested.result;
                                return parse;
                            }
                            script_index = nested.commandStart + nested.commandSize;
                            if (script_array[script_index - 1] == ']' && !nested.incomplete) break block17;
                        } while (script_index != parse.endIndex);
                        if (parse.interp != null) {
                            parse.interp.setResult("missing close-bracket");
                        }
                        parse.termIndex = token.script_index;
                        parse.incomplete = true;
                        parse.result = 1;
                        return parse;
                    }
                    token.type = 16;
                    token.size = script_index - token.script_index;
                    ++parse.numTokens;
                    continue;
                }
                if (cur == '\\') {
                    if (script_array[script_index + 1] == '\n') {
                        if (script_index + 2 == parse.endIndex) {
                            parse.incomplete = true;
                        }
                        if ((mask & 1) != 0) break block16;
                    }
                    token.type = 8;
                    BackSlashResult bs = Parser.backslash(script_array, script_index);
                    token.size = bs.nextIndex - script_index;
                    ++parse.numTokens;
                    script_index += token.size;
                    continue;
                }
                if (cur != '\u0000') break;
                if (script_index != parse.endIndex) {
                    token.type = 4;
                    token.size = 1;
                    ++parse.numTokens;
                    continue;
                }
                break block16;
                break;
            }
            throw new TclRuntimeError("parseTokens encountered unknown character");
        }
        if (parse.numTokens == originalTokens) {
            token.type = 4;
            token.size = 0;
            ++parse.numTokens;
        }
        parse.termIndex = script_index;
        parse.result = 0;
        return var3_3;
    }

    static void evalObjv(Interp interp, TclObject[] objv, int length, int flags) throws TclException {
        interp.resetResult();
        if (objv.length == 0) {
            return;
        }
        if (interp.deleted) {
            TclString.append((TclObject)interp.getResult(), (String)"attempt to call eval in deleted interpreter");
            interp.setErrorCode(TclString.newInstance((String)"CORE IDELETE {attempt to call eval in deleted interpreter}"));
            throw new TclException(1);
        }
        if (interp.nestLevel >= interp.maxNestingDepth) {
            throw new TclException(interp, "too many nested calls to eval (infinite loop?)");
        }
        ++interp.nestLevel;
        try {
            Command cmd = interp.getCommand(objv[0].toString());
            if (cmd == null) {
                TclObject[] newObjv = new TclObject[objv.length + 1];
                int i = objv.length - 1;
                while (i >= 0) {
                    newObjv[i + 1] = objv[i];
                    --i;
                }
                newObjv[0] = TclString.newInstance((String)"unknown");
                newObjv[0].preserve();
                cmd = interp.getCommand("unknown");
                if (cmd == null) {
                    throw new TclException(interp, "invalid command name \"" + objv[0].toString() + "\"");
                }
                Parser.evalObjv(interp, newObjv, length, 0);
                newObjv[0].release();
                Object var9_7 = null;
                --interp.nestLevel;
                return;
            }
            ++interp.cmdCount;
            CallFrame savedVarFrame = interp.varFrame;
            if ((flags & 0x20000) != 0) {
                interp.varFrame = null;
            }
            cmd.cmdProc(interp, objv);
            interp.varFrame = savedVarFrame;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            --interp.nestLevel;
            throw throwable;
        }
        Object var9_8 = null;
        --interp.nestLevel;
    }

    static void logCommandInfo(Interp interp, char[] script_array, int script_index, int cmdIndex, int length, TclException e) {
        String ellipsis;
        int offset;
        if (interp.errAlreadyLogged) {
            return;
        }
        interp.errorLine = 1;
        int pIndex = 0;
        while (pIndex < cmdIndex) {
            if (script_array[pIndex] == '\n') {
                ++interp.errorLine;
            }
            ++pIndex;
        }
        if (length < 0) {
            int script_length = script_array.length - 1;
            length = script_length - cmdIndex;
        }
        if (length > 150) {
            offset = 150;
            ellipsis = "...";
        } else {
            offset = length;
            ellipsis = "";
        }
        String msg = new String(script_array, cmdIndex, offset);
        if (!interp.errInProgress) {
            interp.addErrorInfo("\n    while executing\n\"" + msg + ellipsis + "\"");
        } else {
            interp.addErrorInfo("\n    invoked from within\n\"" + msg + ellipsis + "\"");
        }
        interp.errAlreadyLogged = false;
        e.errIndex = cmdIndex + offset;
    }

    static TclObject evalTokens(Interp interp, TclToken[] tokenList, int tIndex, int count) throws TclException {
        String p = null;
        TclObject result = null;
        while (count > 0) {
            TclToken token = tokenList[tIndex];
            TclObject value = null;
            switch (token.type) {
                case 4: {
                    p = token.getTokenString();
                    break;
                }
                case 8: {
                    BackSlashResult bs = Parser.backslash(token.script_array, token.script_index);
                    if (bs.isWordSep) {
                        p = "\\" + bs.c;
                        break;
                    }
                    Character ch = new Character(bs.c);
                    p = ch.toString();
                    break;
                }
                case 16: {
                    interp.evalFlags |= 1;
                    ++token.script_index;
                    Parser.eval2(interp, token.script_array, token.script_index, token.size - 2, 0);
                    --token.script_index;
                    value = interp.getResult();
                    break;
                }
                case 32: {
                    TclObject index;
                    if (token.numComponents == 1) {
                        index = null;
                    } else {
                        index = Parser.evalTokens(interp, tokenList, tIndex + 2, token.numComponents - 1);
                        if (index == null) {
                            return null;
                        }
                    }
                    String varName = tokenList[tIndex + 1].getTokenString();
                    if (interp.noEval == 0) {
                        if (index != null) {
                            try {
                                value = interp.getVar(varName, index.toString(), 0);
                            }
                            finally {
                                Object var12_13 = null;
                                index.release();
                            }
                        } else {
                            value = interp.getVar(varName, null, 0);
                        }
                    } else {
                        value = TclString.newInstance((String)"");
                        value.preserve();
                    }
                    count -= token.numComponents;
                    tIndex += token.numComponents;
                    break;
                }
                default: {
                    throw new TclRuntimeError("unexpected token type in evalTokens");
                }
            }
            if (result == null) {
                result = value != null ? value : TclString.newInstance((String)p);
                result.preserve();
            } else {
                result = result.takeExclusive();
                if (value != null) {
                    p = value.toString();
                }
                TclString.append((TclObject)result, (String)p);
            }
            ++tIndex;
            --count;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void eval2(Interp interp, char[] script_array, int script_index, int numBytes, int flags) throws TclException {
        int objUsed = 0;
        TclParse parse = null;
        int script_length = script_array.length - 1;
        char[] src_array = script_array;
        int src_index = script_index;
        boolean debug = false;
        if (numBytes < 0) {
            numBytes = script_length - script_index;
        }
        interp.resetResult();
        CallFrame savedVarFrame = interp.varFrame;
        if ((flags & 0x20000) != 0) {
            interp.varFrame = null;
        }
        int bytesLeft = numBytes;
        TclObject[] objv = Parser.grabObjv(interp, 3);
        boolean nested = (interp.evalFlags & 1) != 0;
        interp.evalFlags &= 0xFFFFFFFE;
        do {
            block26: {
                parse = Parser.parseCommand(interp, src_array, src_index, bytesLeft, null, 0, nested);
                if (parse.result != 0) {
                    throw new TclException(parse.result);
                }
                if (parse.numWords > 0 && interp.noEval == 0) {
                    int i;
                    Object var24_20;
                    try {
                        try {
                            int tokenIndex = 0;
                            TclToken token = parse.getToken(tokenIndex);
                            if (objv.length != parse.numWords) {
                                Parser.releaseObjv(interp, objv);
                                objv = Parser.grabObjv(interp, parse.numWords);
                            }
                            objUsed = 0;
                            while (true) {
                                if (objUsed >= parse.numWords) {
                                    try {
                                        Parser.evalObjv(interp, objv, bytesLeft, 0);
                                        break;
                                    }
                                    catch (StackOverflowError e) {
                                        interp.setResult("too many nested calls to eval (infinite loop?)");
                                        throw new TclException(1);
                                    }
                                }
                                TclObject obj = Parser.evalTokens(interp, parse.tokenList, tokenIndex + 1, token.numComponents);
                                if (obj == null) {
                                    throw new TclException(1);
                                }
                                objv[objUsed] = obj;
                                token = parse.getToken(tokenIndex += token.numComponents + 1);
                                ++objUsed;
                            }
                            var24_20 = null;
                            i = 0;
                        }
                        catch (TclException e) {
                            if (e.getCompletionCode() == 1 && !interp.errAlreadyLogged) {
                                int commandLength = parse.commandSize;
                                if (parse.commandStart + commandLength != script_index + numBytes) {
                                    --commandLength;
                                }
                                interp.varFrame = savedVarFrame;
                                Parser.logCommandInfo(interp, script_array, script_index, parse.commandStart, commandLength, e);
                            }
                            throw e;
                        }
                        while (true) {
                            if (i >= objUsed) {
                                objUsed = 0;
                                parse.release();
                                break block26;
                            }
                            objv[i].release();
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        var24_20 = null;
                        i = 0;
                    }
                    while (true) {
                        if (i >= objUsed) {
                            objUsed = 0;
                            parse.release();
                            throw throwable;
                        }
                        objv[i].release();
                        ++i;
                    }
                }
            }
            int nextIndex = parse.commandStart + parse.commandSize;
            bytesLeft -= nextIndex - src_index;
            src_index = nextIndex;
            if (!nested || src_index <= 1 || src_array[src_index - 1] != ']') continue;
            interp.termOffset = src_index - 1 - script_index;
            interp.varFrame = savedVarFrame;
            Object var22_25 = null;
            if (parse != null) {
                parse.release();
            }
            Parser.releaseObjv(interp, objv);
            return;
        } while (bytesLeft > 0);
        interp.termOffset = src_index - script_index;
        interp.varFrame = savedVarFrame;
        return;
        finally {
            Object var22_26 = null;
            if (parse != null) {
                parse.release();
            }
            Parser.releaseObjv(interp, objv);
        }
    }

    static TclParse parseVarName(Interp interp, char[] script_array, int script_index, int numBytes, TclParse parse, boolean append) {
        boolean debug = false;
        int endIndex = numBytes >= 0 ? script_index + numBytes : script_array.length - 1;
        if (!append) {
            parse = new TclParse(interp, script_array, endIndex, null, -1);
        }
        TclToken token = parse.getToken(parse.numTokens);
        token.type = 32;
        token.script_array = script_array;
        token.script_index = script_index++;
        int varIndex = parse.numTokens++;
        if (script_index >= endIndex) {
            token.type = 4;
            token.size = 1;
            token.numComponents = 0;
            parse.result = 0;
            return parse;
        }
        TclToken startToken = token;
        token = parse.getToken(parse.numTokens);
        if (script_array[script_index] == '{') {
            token.type = 4;
            token.script_array = script_array;
            token.script_index = ++script_index;
            token.numComponents = 0;
            while (true) {
                if (script_index == endIndex) {
                    if (interp != null) {
                        interp.setResult("missing close-brace for variable name");
                    }
                    parse.termIndex = token.script_index - 1;
                    parse.incomplete = true;
                    parse.result = 1;
                    return parse;
                }
                if (script_array[script_index] == '}') break;
                ++script_index;
            }
            token.size = script_index - token.script_index;
            startToken.size = script_index - startToken.script_index;
            ++parse.numTokens;
            ++script_index;
        } else {
            token.type = 4;
            token.script_array = script_array;
            token.script_index = script_index;
            token.numComponents = 0;
            while (script_index != endIndex) {
                char cur = script_array[script_index];
                if (Character.isLetterOrDigit(cur) || cur == '_') {
                    ++script_index;
                    continue;
                }
                if (cur != ':' || script_index + 1 == endIndex || script_array[script_index + 1] != ':') break;
                script_index += 2;
                while (script_index != endIndex && script_array[script_index] == ':') {
                    ++script_index;
                }
            }
            token.size = script_index - token.script_index;
            if (token.size == 0) {
                startToken.type = 4;
                startToken.size = 1;
                startToken.numComponents = 0;
                parse.result = 0;
                return parse;
            }
            ++parse.numTokens;
            if (script_index != endIndex && script_array[script_index] == '(') {
                parse = Parser.parseTokens(script_array, ++script_index, 16, parse);
                if (parse.result != 0) {
                    return parse;
                }
                if (parse.termIndex == endIndex || parse.string[parse.termIndex] != ')') {
                    if (interp != null) {
                        interp.setResult("missing )");
                    }
                    parse.termIndex = script_index - 1;
                    parse.incomplete = true;
                    parse.result = 1;
                    return parse;
                }
                script_index = parse.termIndex + 1;
            }
        }
        startToken.size = script_index - startToken.script_index;
        startToken.numComponents = parse.numTokens - (varIndex + 1);
        parse.result = 0;
        return parse;
    }

    static ParseResult parseVar(Interp interp, String string) throws TclException {
        ParseResult parseResult;
        boolean debug = false;
        CharPointer src = new CharPointer(string);
        TclParse parse = Parser.parseVarName(interp, src.array, src.index, -1, null, false);
        try {
            if (parse.numTokens == 1) {
                ParseResult parseResult2 = new ParseResult("$", 1);
                Object var7_7 = null;
                parse.release();
                return parseResult2;
            }
            TclObject obj = Parser.evalTokens(interp, parse.tokenList, 0, parse.numTokens);
            if (!obj.isShared()) {
                throw new TclRuntimeError("parseVar got temporary object from evalTokens");
            }
            obj.release();
            parseResult = new ParseResult(obj, parse.tokenList[0].size);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            parse.release();
            throw throwable;
        }
        Object var7_8 = null;
        parse.release();
        return parseResult;
    }

    static boolean commandComplete(String string, int length) {
        TclParse parse;
        CharPointer src = new CharPointer(string);
        do {
            parse = Parser.parseCommand(null, src.array, src.index, length, null, 0, false);
            src.index = parse.commandStart + parse.commandSize;
            parse.release();
            if (src.index >= length) break;
            ++src.index;
        } while (parse.result == 0);
        return !parse.incomplete;
    }

    static boolean objCommandComplete(TclObject obj) {
        String string = obj.toString();
        return Parser.commandComplete(string, string.length());
    }

    static BackSlashResult backslash(char[] script_array, int script_index) {
        int endIndex = script_array.length - 1;
        if (++script_index == endIndex) {
            return new BackSlashResult('\\', script_index);
        }
        char c = script_array[script_index];
        switch (c) {
            case 'a': {
                return new BackSlashResult('\u0007', script_index + 1);
            }
            case 'b': {
                return new BackSlashResult('\b', script_index + 1);
            }
            case 'f': {
                return new BackSlashResult('\f', script_index + 1);
            }
            case 'n': {
                return new BackSlashResult('\n', script_index + 1);
            }
            case 'r': {
                return new BackSlashResult('\r', script_index + 1);
            }
            case 't': {
                return new BackSlashResult('\t', script_index + 1);
            }
            case 'v': {
                return new BackSlashResult('\u000b', script_index + 1);
            }
            case 'x': {
                if (++script_index < endIndex && ((c = script_array[script_index]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                    String str = new String(script_array, script_index, endIndex - script_index);
                    StrtoulResult res = Util.strtoul(str, 0, 16);
                    if (res.errno == 0) {
                        byte b = (byte)(res.value & 0xFFL);
                        return new BackSlashResult((char)b, script_index + res.index);
                    }
                }
                return new BackSlashResult('x', script_index);
            }
            case 'u': {
                int result = 0;
                int count = 0;
                while (count < 4) {
                    if (!((c = script_array[++script_index]) >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F')) break;
                    int n = c - 48;
                    if (n > 9) {
                        n = n + 48 + 10 - 65;
                    }
                    if (n > 16) {
                        n = n + 65 - 97;
                    }
                    result = (result << 4) + n;
                    ++count;
                }
                if (count == 0) {
                    result = 117;
                }
                return new BackSlashResult((char)result, script_index);
            }
            case '\n': 
            case '\r': {
                if (c == '\r' && script_index + 1 < endIndex && script_array[script_index + 1] == '\n') {
                    ++script_index;
                }
                do {
                    c = script_array[++script_index];
                } while (script_index < endIndex && (c == ' ' || c == '\t'));
                return new BackSlashResult(' ', script_index);
            }
            case '\u0000': {
                return new BackSlashResult('\\', script_index + 1);
            }
        }
        if (c >= '0' && c <= '9') {
            int result = c - 48;
            if (++script_index != endIndex && (c = script_array[script_index]) >= '0' && c <= '9') {
                result = result * 8 + (c - 48);
                if (++script_index != endIndex && (c = script_array[script_index]) >= '0' && c <= '9') {
                    result = result * 8 + (c - 48);
                    ++script_index;
                }
            }
            return new BackSlashResult((char)(result & 0xFF), script_index);
        }
        return new BackSlashResult(c, script_index + 1);
    }

    static char charType(char c) {
        return c > '\u007f' ? (char)'\u0000' : typeTable[c];
    }

    /*
     * WARNING - void declaration
     */
    static void init(Interp interp) {
        void var2_2;
        TclObject[][][] OBJV = new TclObject[10][][];
        int[] USED = new int[10];
        int i = 0;
        while (i < 10) {
            int size = OBJV_CACHE_SIZES[i];
            OBJV[i] = new TclObject[size][];
            USED[i] = 0;
            int j = 0;
            while (j < size) {
                OBJV[i][j] = new TclObject[i];
                ++j;
            }
            ++i;
        }
        interp.parserObjv = OBJV;
        interp.parserObjvUsed = var2_2;
    }

    private static TclObject[] grabObjv(Interp interp, int size) {
        if (size >= 10) {
            return new TclObject[size];
        }
        int OPEN = interp.parserObjvUsed[size];
        if (OPEN < OBJV_CACHE_SIZES[size]) {
            int n = size;
            interp.parserObjvUsed[n] = interp.parserObjvUsed[n] + 1;
            return interp.parserObjv[size][OPEN];
        }
        return new TclObject[size];
    }

    private static void releaseObjv(Interp interp, TclObject[] objv) {
        int size = objv.length;
        if (size >= 10) {
            return;
        }
        int OPEN = interp.parserObjvUsed[size];
        if (OPEN > 0) {
            interp.parserObjvUsed[size] = --OPEN;
            interp.parserObjv[size][OPEN] = objv;
        }
    }

    Parser() {
    }
}

