'\"
'\" Copyright (c) 2007 Donal K. Fellows
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: @(#) $Id: self.n,v 1.2 2008/10/17 10:22:25 dkf Exp $
'\"
.so man.macros
.TH self n 0.1 TclOO "TclOO Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
self \- method call internal introspection
.SH SYNOPSIS
.nf
package require TclOO

\fBself\fR ?\fIsubcommand\fR?
.fi
.BE
.SH DESCRIPTION
The \fBself\fR command, which should only be used from within the context of a
call to a method (i.e. inside a method, constructor or destructor body) is
used to allow the method to discover information about how it was called. It
takes an argument, \fIsubcommand\fR, that tells it what sort of information is
actually desired; if omitted the result will be the same as if \fBself
object\fR was invoked. The supported subcommands are:
.TP
\fBself caller\fR
.
When the method was invoked from inside another object method, this subcommand
returns a three element list describing the containing object and method. The
first element describes the declaring object or class of the method, the
second element is the name of the object on which the containing method was
invoked, and the third element is the name of the method (with the strings
\fB<constructor>\fR and \fB<destructor>\fR indicating constructors and
destructors respectively).
.TP
\fBself class\fR
.
This returns the name of the class or object that the current method was
defined within. Note that this will change as the chain of method
implementations is traversed with \fBnext\fR.
.TP
\fBself filter\fR
.
When invoked inside a filter, this subcommand returns a three element list
describing the filter. The first element gives the name of the object or class
that declared the filter (note that this may be different from the object or
class that provided the implementation of the filter), the second element is
either \fBobject\fR or \fBclass\fR depending on whether the declaring entity
was an object or class, and the third element is the name of the filter.
.TP
\fBself method\fR
.
This returns the name of the current method (with the strings
\fB<constructor>\fR and \fB<destructor>\fR indicating constructors and
destructors respectively).
.TP
\fBself namespace\fR
.
This returns the name of the unique namespace of the object that the method
was invoked upon.
.TP
\fBself next\fR
.
When invoked from a method that is not at the end of a call chain (i.e. where
the \fBnext\fR command will invoke an actual method implementation), this
subcommand returns a two element list describing the next element in the
method call chain; the first element is the name of the class or object that
declares the next part of the call chain, and the second element is the name
of the method (with the strings \fB<constructor>\fR and \fB<destructor>\fR
indicating constructors and destructors respectively). If invoked from a
method that is at the end of a call chain, this subcommand returns the emtpy
string.
.TP
\fBself object\fR
.
This returns the name of the object that the method was invoked upon.
.TP
\fBself target\fR
.
When invoked inside a filter implementation, this subcommand returns a two
element list describing the method being filtered. The first element will be
the name of the declarer of the method, and the second element will be the
actual name of the method.
.SH EXAMPLES
.PP
This example shows basic use of \fBself\fR to provide information about the
current object:
.PP
.CS
oo::class create c {
    method foo {} {
        puts "this is the [\fBself\fR] object"
    }
}
c create a
c create b
a foo                \fI\(-> prints "this is the ::a object"\fR
b foo                \fI\(-> prints "this is the ::b object"\fR
.CE
.SH "SEE ALSO"
info(n), next(n)
.SH KEYWORDS
call, introspection, object
.\" Local variables:
.\" mode: nroff
.\" fill-column: 78
.\" End:
