.\" tdbc.n --
.\"
.\" Copyright (c) 2008 by Kevin B. Kenny.
.\"
.\" See the file "license.terms" for information on usage and redistribution of
.\" this file, and for a DISCLAIMER OF ALL WARRANTIES.
.\" .so man.macros
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.TH "tdbc" n 8.6 Tcl "Tcl Database Connectivity"
.BS
.SH "NAME"
tdbc \- Tcl Database Connectivity
.SH "SYNOPSIS"
package require \fBtdbc 1.0\fR
.sp
package require \fBtdbc::\fR\fIdriver version\fR
.sp
\fBtdbc::\fR\fIdriver\fR\fB::connection create \fR\fIdb\fR \fI?\-option value\fR...?
.BE
.SH "DESCRIPTION"
.PP
Tcl Database Connectivity (TDBC) is a common interface for Tcl
programs to access SQL databases. It is implemented by a series of
database \fIdrivers:\fR separate modules, each of which adapts Tcl to
the interface of one particular database system.  All of the drivers
implement a common series of commands for manipulating the database.
These commands are all named dynamically, since they all represent
objects in the database system. They include \fBconnections,\fR
which represent connections to a database; \fBstatements,\fR which
represent SQL statements, and \fBresult sets,\fR which represent
the sets of rows that result from executing statements. All of these
have manual pages of their own, listed under \fBSEE ALSO\fR.
.PP
In addition, TDBC itself has a few service procedures that are chiefly
of interest to driver writers. \fBSEE ALSO\fR also enumerates them.
.SH "SEE ALSO"
tdbc_connection(n), tdbc_resultSet(n), tdbc_statement(n), tdbc_tokenize(n)
.SH "KEYWORDS"
TDBC, SQL, database, connectivity, connection, resultset, statement
.SH "COPYRIGHT"
Copyright (c) 2008 by Kevin B. Kenny.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\"
