# factorial.tcl --
#
#  This package implements a procedure that calculates the factorial of
#  a number.
#
# Copyright (c) 1998-1999 by Scriptics Corporation.
# All rights reserved.
# 
# RCS: @(#) $Id: factorial.tcl,v 1.2 1999/02/02 23:29:30 suresh Exp $

package provide factorial 1.0

namespace eval factorial {
    namespace export calculate
}

# factorial::calculate --
#
#  Calculates the factorial of a number.
#
# Arguments:
#  number	the number whose factorial we want to calculate
#
# Results:
#  Returns the factorial of the argument

proc factorial::calculate {number} {
    if {$number <= 1} {
	return 1
    }

    return [expr {$number * [calculate [expr {$number - 1}]]}]
}
