/* 
 * proTclUnixMain.c --
 *
 *	Provides a default version of the main program and Tcl_AppInit
 *	procedure for Tcl applications (without Tk).
 *
 * Copyright (c) 1998 Scriptics Corporation
 * All rights reserved.
 *
 * RCS: @(#) $Id: proTclUnixMain.c,v 1.9 1999/02/02 23:31:03 suresh Exp $
 */

#include "tcl.h"
#ifdef ITCL_STATIC_BUILD
#include "itcl.h"
#endif
#ifdef EXPECT_STATIC_BUILD
#include "expect_tcl.h"
#endif
#ifdef TCLX_STATIC_BUILD
#include "tclExtend.h"
#endif
#include <proTbcLoad.h>
#include <proWrap.h>


/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

extern int matherr();
int *tclDummyMathPtr = (int *) matherr;


static int		ProTclAppInit _ANSI_ARGS_((Tcl_Interp *interp));

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tcl_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
{
    Pro_WrapTclMain(argc, argv, ProTclAppInit);

    return 0;			/* Needed only to prevent compiler warning. */
}

/*
 *----------------------------------------------------------------------
 *
 * ProTclAppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

static int
ProTclAppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    if (Tbcload_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
    Tcl_StaticPackage((Tcl_Interp *)NULL,
		      "tbcload", Tbcload_Init, Tbcload_SafeInit);

#ifdef ITCL_STATIC_BUILD
    Tcl_StaticPackage((Tcl_Interp *)NULL,
		      "Itcl", Itcl_Init, Itcl_SafeInit);
#endif

#ifdef EXPECT_STATIC_BUILD
    Tcl_StaticPackage((Tcl_Interp *)NULL,
		      "Expect", Expect_Init, (Tcl_PackageInitProc *) NULL);
#endif

#ifdef TCLX_STATIC_BUILD
    Tcl_StaticPackage ((Tcl_Interp *)NULL,
		       "Tclx", Tclx_Init, Tclx_SafeInit);
#endif

    return TCL_OK;
}
