/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.model;

/**
 * Component model path names.
 */
public class ModelConstants {

    public static final String ABI_OPTIONS = "android.abis";

    public static final String ANDROID_BUILDER = "androidBuilder";

    public static final String ANDROID_CONFIG_ADAPTOR = "androidConfigAdaptor";

    public static final String ARTIFACTS = "artifacts";

    public static final String BINARIES = "binaries";

    public static final String NATIVE_BUILD_SYSTEMS = "nativeBuildSystems";

    public static final String COMPONENTS = "components";

    public static final String EXTERNAL_BUILD_CONFIG = "nativeBuildConfig";

    public static final String EXTERNAL_CONFIG_FILES = "nativeBuild";

    public static final String EXTRA_MODEL_INFO = "extraModelInfo";

    public static final String IS_APPLICATION = "isApplication";

    public static final String JNILIBS_DEPENDENCIES = "jniLibsDependencies";

    public static final String NATIVE_DEPENDENCIES = "nativeDependencies";

    public static final String NDK_HANDLER = "ndkHandler";

    public static final String TASK_MANAGER = "taskManager";

    public static final String NATIVE_BUILD_CONFIG_VALUES = "nativeBuildConfigValues";
}
