# How to Contribute

ScaleFT's projects are [Apache 2.0 licensed](LICENSE) and accept contributions
via GitHub pull requests. This document outlines some of the conventions on
development workflow, contact points, community conduct and other resources
to make it easier to get your contribution accepted.

# Code of Conduct

This project adheres to the Contributor Covenant [code of conduct](CODE_OF_CONDUCT.md).
By participating, you are expected to uphold this code.

Please report unacceptable behavior to [opensource@scaleft.com](mailto:opensource@scaleft.com).

# Reporting Security Issues

ScaleFT takes security seriously. If you discover a security issue, 
please bring it to our attention right away!

Please DO NOT file a public issue or pull request,
[instead send your report privately to the ScaleFT Security Team](https://www.scaleft.com/company/security/),
reachable at [security@scaleft.com](mailto:security@scaleft.com).

Security reports are greatly appreciated and we will publicly thank you for them.

# Getting Started

- Fork the repository on GitHub
- Read the [README](README.md) for build and test instructions
- Play with the project, submit bugs, submit patches!

# Contribution Flow

This is a rough outline of what a contributor's workflow looks like:

- Create a topic branch from where you want to base your work (usually master).
- Make commits of logical units, rebasing later is ok too!
- Push your changes to a topic branch in your fork of the repository.
- Make sure the tests pass, and add any new tests as appropriate.
- Submit a pull request to the original repository.

Thanks for your contributions!
