/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "account_spec.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifndef AB_ACCOUNT_SPEC_ACCOUNT_SPEC_H
#define AB_ACCOUNT_SPEC_ACCOUNT_SPEC_H


#ifdef __cplusplus
extern "C" {
#endif

/** @page P_AB_ACCOUNT_SPEC Structure AB_ACCOUNT_SPEC
<p>This page describes the properties of AB_ACCOUNT_SPEC.</p>



<h1>AB_ACCOUNT_SPEC</h1>

This type contains all important information about accounts. All text fields are in UTF-8.


<h2>Type</h2>



@anchor AB_ACCOUNT_SPEC_type
<h3>type</h3>

<p>Set this property with @ref AB_AccountSpec_SetType(), get it with @ref AB_AccountSpec_GetType().</p>


<h2>Identifiers</h2>



@anchor AB_ACCOUNT_SPEC_uniqueId
<h3>uniqueId</h3>

This is a unique id assigned by AqBanking.
<p>Set this property with @ref AB_AccountSpec_SetUniqueId(), get it with @ref AB_AccountSpec_GetUniqueId().</p>


<h2>Common Information</h2>



@anchor AB_ACCOUNT_SPEC_backendName
<h3>backendName</h3>

Name of the banking backend this account belongs to.
<p>Set this property with @ref AB_AccountSpec_SetBackendName(), get it with @ref AB_AccountSpec_GetBackendName().</p>


@anchor AB_ACCOUNT_SPEC_ownerName
<h3>ownerName</h3>

Name of the account owner as it is stored with the bank.
<p>Set this property with @ref AB_AccountSpec_SetOwnerName(), get it with @ref AB_AccountSpec_GetOwnerName().</p>


@anchor AB_ACCOUNT_SPEC_accountName
<h3>accountName</h3>

Name of the account.
<p>Set this property with @ref AB_AccountSpec_SetAccountName(), get it with @ref AB_AccountSpec_GetAccountName().</p>


@anchor AB_ACCOUNT_SPEC_currency
<h3>currency</h3>

Currency used with this account.
<p>Set this property with @ref AB_AccountSpec_SetCurrency(), get it with @ref AB_AccountSpec_GetCurrency().</p>


@anchor AB_ACCOUNT_SPEC_memo
<h3>memo</h3>

Optional additional info.
<p>Set this property with @ref AB_AccountSpec_SetMemo(), get it with @ref AB_AccountSpec_GetMemo().</p>


<h2>SEPA Account Specification</h2>



@anchor AB_ACCOUNT_SPEC_iban
<h3>iban</h3>

Internation bank account number as specified by the SEPA specs.
<p>Set this property with @ref AB_AccountSpec_SetIban(), get it with @ref AB_AccountSpec_GetIban().</p>


@anchor AB_ACCOUNT_SPEC_bic
<h3>bic</h3>

SWIFT code of the bank at which this account is registered.
<p>Set this property with @ref AB_AccountSpec_SetBic(), get it with @ref AB_AccountSpec_GetBic().</p>


<h2>Non-SEPA Account Specification</h2>



@anchor AB_ACCOUNT_SPEC_country
<h3>country</h3>

<p>Set this property with @ref AB_AccountSpec_SetCountry(), get it with @ref AB_AccountSpec_GetCountry().</p>


@anchor AB_ACCOUNT_SPEC_bankCode
<h3>bankCode</h3>

National bank code (e.g. BLZ in Germany, routing number in other countries).
<p>Set this property with @ref AB_AccountSpec_SetBankCode(), get it with @ref AB_AccountSpec_GetBankCode().</p>


@anchor AB_ACCOUNT_SPEC_bankName
<h3>bankName</h3>

National bank name
<p>Set this property with @ref AB_AccountSpec_SetBankName(), get it with @ref AB_AccountSpec_GetBankName().</p>


@anchor AB_ACCOUNT_SPEC_branchId
<h3>branchId</h3>

This is the branch id of the local bank (OFX only)
<p>Set this property with @ref AB_AccountSpec_SetBranchId(), get it with @ref AB_AccountSpec_GetBranchId().</p>


@anchor AB_ACCOUNT_SPEC_accountNumber
<h3>accountNumber</h3>

Account number in national account specification.
<p>Set this property with @ref AB_AccountSpec_SetAccountNumber(), get it with @ref AB_AccountSpec_GetAccountNumber().</p>


@anchor AB_ACCOUNT_SPEC_subAccountNumber
<h3>subAccountNumber</h3>

If your account has subaccounts which are distinguished by different suffixes, then this is that suffix. Otherwise it's empty. (HBCI only)
<p>Set this property with @ref AB_AccountSpec_SetSubAccountNumber(), get it with @ref AB_AccountSpec_GetSubAccountNumber().</p>


<h2>Transaction Limits</h2>



@anchor AB_ACCOUNT_SPEC_transactionLimitsList
<h3>transactionLimitsList</h3>

This list contains one ABS_TRANSACTION_HINTS object per command allowed with this account. Not every backend supports transaction hints, so this list might be entirely empty or missing some entries.
<p>Set this property with @ref AB_AccountSpec_SetTransactionLimitsList(), get it with @ref AB_AccountSpec_GetTransactionLimitsList().</p>

*/

/* needed system headers */
#include <gwenhywfar/types.h>
#include <gwenhywfar/list1.h>
#include <gwenhywfar/list2.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/xml.h>

/* pre-headers */
#include <aqbanking/error.h>
#include <gwenhywfar/gwendate.h>
#include <gwenhywfar/mdigest.h>
#include <gwenhywfar/text.h>
#include <gwenhywfar/buffer.h>

typedef struct AB_ACCOUNT_SPEC AB_ACCOUNT_SPEC;
GWEN_LIST_FUNCTION_LIB_DEFS(AB_ACCOUNT_SPEC, AB_AccountSpec, AQBANKING_API)
GWEN_LIST2_FUNCTION_LIB_DEFS(AB_ACCOUNT_SPEC, AB_AccountSpec, AQBANKING_API)



/* post-headers */
#include <aqbanking/account_type.h>
#include <aqbanking/types/transaction.h>
#include <aqbanking/types/transactionlimits.h>


/** Constructor. */
AQBANKING_API AB_ACCOUNT_SPEC *AB_AccountSpec_new(void);

/** Destructor. */
AQBANKING_API void AB_AccountSpec_free(AB_ACCOUNT_SPEC *p_struct);

AQBANKING_API void AB_AccountSpec_Attach(AB_ACCOUNT_SPEC *p_struct);

AQBANKING_API AB_ACCOUNT_SPEC *AB_AccountSpec_dup(const AB_ACCOUNT_SPEC *p_struct);

AQBANKING_API AB_ACCOUNT_SPEC *AB_AccountSpec_copy(AB_ACCOUNT_SPEC *p_struct, const AB_ACCOUNT_SPEC *p_src);

/** Getter.
 * Use this function to get the member "type" (see @ref AB_ACCOUNT_SPEC_type)
*/
AQBANKING_API int AB_AccountSpec_GetType(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "uniqueId" (see @ref AB_ACCOUNT_SPEC_uniqueId)
*/
AQBANKING_API uint32_t AB_AccountSpec_GetUniqueId(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "backendName" (see @ref AB_ACCOUNT_SPEC_backendName)
*/
AQBANKING_API const char *AB_AccountSpec_GetBackendName(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "ownerName" (see @ref AB_ACCOUNT_SPEC_ownerName)
*/
AQBANKING_API const char *AB_AccountSpec_GetOwnerName(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "accountName" (see @ref AB_ACCOUNT_SPEC_accountName)
*/
AQBANKING_API const char *AB_AccountSpec_GetAccountName(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "currency" (see @ref AB_ACCOUNT_SPEC_currency)
*/
AQBANKING_API const char *AB_AccountSpec_GetCurrency(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "memo" (see @ref AB_ACCOUNT_SPEC_memo)
*/
AQBANKING_API const char *AB_AccountSpec_GetMemo(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "iban" (see @ref AB_ACCOUNT_SPEC_iban)
*/
AQBANKING_API const char *AB_AccountSpec_GetIban(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "bic" (see @ref AB_ACCOUNT_SPEC_bic)
*/
AQBANKING_API const char *AB_AccountSpec_GetBic(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "country" (see @ref AB_ACCOUNT_SPEC_country)
*/
AQBANKING_API const char *AB_AccountSpec_GetCountry(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "bankCode" (see @ref AB_ACCOUNT_SPEC_bankCode)
*/
AQBANKING_API const char *AB_AccountSpec_GetBankCode(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "bankName" (see @ref AB_ACCOUNT_SPEC_bankName)
*/
AQBANKING_API const char *AB_AccountSpec_GetBankName(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "branchId" (see @ref AB_ACCOUNT_SPEC_branchId)
*/
AQBANKING_API const char *AB_AccountSpec_GetBranchId(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "accountNumber" (see @ref AB_ACCOUNT_SPEC_accountNumber)
*/
AQBANKING_API const char *AB_AccountSpec_GetAccountNumber(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "subAccountNumber" (see @ref AB_ACCOUNT_SPEC_subAccountNumber)
*/
AQBANKING_API const char *AB_AccountSpec_GetSubAccountNumber(const AB_ACCOUNT_SPEC *p_struct);

/** Getter.
 * Use this function to get the member "transactionLimitsList" (see @ref AB_ACCOUNT_SPEC_transactionLimitsList)
*/
AQBANKING_API AB_TRANSACTION_LIMITS_LIST *AB_AccountSpec_GetTransactionLimitsList(const AB_ACCOUNT_SPEC *p_struct);

/** Setter.
 * Use this function to set the member "type" (see @ref AB_ACCOUNT_SPEC_type)
*/
AQBANKING_API void AB_AccountSpec_SetType(AB_ACCOUNT_SPEC *p_struct, int p_src);

/** Setter.
 * Use this function to set the member "uniqueId" (see @ref AB_ACCOUNT_SPEC_uniqueId)
*/
AQBANKING_API void AB_AccountSpec_SetUniqueId(AB_ACCOUNT_SPEC *p_struct, uint32_t p_src);

/** Setter.
 * Use this function to set the member "backendName" (see @ref AB_ACCOUNT_SPEC_backendName)
*/
AQBANKING_API void AB_AccountSpec_SetBackendName(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "ownerName" (see @ref AB_ACCOUNT_SPEC_ownerName)
*/
AQBANKING_API void AB_AccountSpec_SetOwnerName(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "accountName" (see @ref AB_ACCOUNT_SPEC_accountName)
*/
AQBANKING_API void AB_AccountSpec_SetAccountName(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "currency" (see @ref AB_ACCOUNT_SPEC_currency)
*/
AQBANKING_API void AB_AccountSpec_SetCurrency(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "memo" (see @ref AB_ACCOUNT_SPEC_memo)
*/
AQBANKING_API void AB_AccountSpec_SetMemo(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "iban" (see @ref AB_ACCOUNT_SPEC_iban)
*/
AQBANKING_API void AB_AccountSpec_SetIban(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bic" (see @ref AB_ACCOUNT_SPEC_bic)
*/
AQBANKING_API void AB_AccountSpec_SetBic(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "country" (see @ref AB_ACCOUNT_SPEC_country)
*/
AQBANKING_API void AB_AccountSpec_SetCountry(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bankCode" (see @ref AB_ACCOUNT_SPEC_bankCode)
*/
AQBANKING_API void AB_AccountSpec_SetBankCode(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bankName" (see @ref AB_ACCOUNT_SPEC_bankName)
*/
AQBANKING_API void AB_AccountSpec_SetBankName(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "branchId" (see @ref AB_ACCOUNT_SPEC_branchId)
*/
AQBANKING_API void AB_AccountSpec_SetBranchId(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "accountNumber" (see @ref AB_ACCOUNT_SPEC_accountNumber)
*/
AQBANKING_API void AB_AccountSpec_SetAccountNumber(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "subAccountNumber" (see @ref AB_ACCOUNT_SPEC_subAccountNumber)
*/
AQBANKING_API void AB_AccountSpec_SetSubAccountNumber(AB_ACCOUNT_SPEC *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "transactionLimitsList" (see @ref AB_ACCOUNT_SPEC_transactionLimitsList)
*/
AQBANKING_API void AB_AccountSpec_SetTransactionLimitsList(AB_ACCOUNT_SPEC *p_struct,
                                                           AB_TRANSACTION_LIMITS_LIST *p_src);

/* list1 functions */
AQBANKING_API AB_ACCOUNT_SPEC_LIST *AB_AccountSpec_List_dup(const AB_ACCOUNT_SPEC_LIST *p_src);

AQBANKING_API void AB_AccountSpec_ReadDb(AB_ACCOUNT_SPEC *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API int AB_AccountSpec_WriteDb(const AB_ACCOUNT_SPEC *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API AB_ACCOUNT_SPEC *AB_AccountSpec_fromDb(GWEN_DB_NODE *p_db);

AQBANKING_API int AB_AccountSpec_toDb(const AB_ACCOUNT_SPEC *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API void AB_AccountSpec_ReadXml(AB_ACCOUNT_SPEC *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API void AB_AccountSpec_WriteXml(const AB_ACCOUNT_SPEC *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API void AB_AccountSpec_toXml(const AB_ACCOUNT_SPEC *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API AB_ACCOUNT_SPEC *AB_AccountSpec_fromXml(GWEN_XMLNODE *p_db);

AQBANKING_API AB_ACCOUNT_SPEC *AB_AccountSpec_List_GetByUniqueId(const AB_ACCOUNT_SPEC_LIST *p_list, uint32_t p_cmp);

/**
 * Check whether a given account info object matches the given criteria.
 * @param a account info object to match
 * @param backendName name of the banking backend (wildcards and jokers allowed)
 * @param country ISO code of the country (wildcards and jokers allowed)
 * @param bankId bank code to search for (wildcards and jokers allowed)
 * @param accountNumber account number to search for (wildcards and jokers allowed)
 * @param subAccountId sub account number (wildcards and jokers allowed)
 * @param iban IBAN to search for (wildcards and jokers allowed)
 * @param currency currecny the account uses (wildcards and jokers allowed)
 * @param ty account type (use AB_AccountType_Unknown as wildcard)
 */
AQBANKING_API int AB_AccountSpec_Matches(const AB_ACCOUNT_SPEC *a, const char *backendName, const char *country,
                                         const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency,
                                         int ty);
/**
 * Find the first matching account info object in a list of account info objects.
 * @param al list of account info objects among to search
 * @param backendName name of the banking backend (wildcards and jokers allowed)
 * @param country ISO code of the country (wildcards and jokers allowed)
 * @param bankId bank code to search for (wildcards and jokers allowed)
 * @param accountNumber account number to search for (wildcards and jokers allowed)
 * @param subAccountId sub account number (wildcards and jokers allowed)
 * @param iban IBAN to search for (wildcards and jokers allowed)
 * @param currency currecny the account uses (wildcards and jokers allowed)
 * @param ty account type (use AB_AccountType_Unknown as wildcard)
 */
AQBANKING_API AB_ACCOUNT_SPEC *AB_AccountSpec_List_FindFirst(const AB_ACCOUNT_SPEC_LIST *al,
                                                             const char *backendName,
                                                             const char *country,
                                                             const char *bankId,
                                                             const char *accountNumber,
                                                             const char *subAccountId,
                                                             const char *iban,
                                                             const char *currency,
                                                             int ty);
/**
 * Find the next matching account info object in a list of account info objects.
 * @param a previous matching account info objects among to search
 * @param backendName name of the banking backend (wildcards and jokers allowed)
 * @param country ISO code of the country (wildcards and jokers allowed)
 * @param bankId bank code to search for (wildcards and jokers allowed)
 * @param accountNumber account number to search for (wildcards and jokers allowed)
 * @param subAccountId sub account number (wildcards and jokers allowed)
 * @param iban IBAN to search for (wildcards and jokers allowed)
 * @param currency currecny the account uses (wildcards and jokers allowed)
 * @param ty account type (use AB_AccountType_Unknown as wildcard)
 */
AQBANKING_API AB_ACCOUNT_SPEC *AB_AccountSpec_List_FindNext(AB_ACCOUNT_SPEC *a, const char *backendName,
                                                            const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban,
                                                            const char *currency, int ty);
AQBANKING_API AB_TRANSACTION_LIMITS *AB_AccountSpec_GetTransactionLimitsForCommand(const AB_ACCOUNT_SPEC *st, int cmd);
AQBANKING_API void AB_AccountSpec_AddTransactionLimits(AB_ACCOUNT_SPEC *st, AB_TRANSACTION_LIMITS *l);
/* end-headers */


#ifdef __cplusplus
}
#endif

#endif

