#!/bin/bash

# Run this from project root directory
go mod vendor

# Download only the dependencies that are not yet available in Debian
MODULES=(
  "github.com/micro-editor/terminal"
)

# Loop through each module
for MODULE in "${MODULES[@]}"
do
  rm -rf debian/vendor/"$MODULE"
  mkdir -p debian/vendor/"$MODULE"
  cp --archive --update --verbose vendor/"$MODULE"/* debian/vendor/"$MODULE"/
  rm -rf vendor/"$MODULE"
done
