var plugins = [];

switch(process.env.TRANSPILE) {
case 'babel7':
    var babel=require('rollup-plugin-babel');
    const plugins_babel7 = [
      babel(),
    ];
    plugins = plugins_babel7; break;
case 'none':
    plugins = []; break;
default:
    var buble=require('rollup-plugin-buble');
    const plugins_buble = [
      buble()
    ];
    plugins = plugins_buble;
}

const pkg = require('../packages/json/package.json');

const external = Object.keys(pkg.dependencies);

export default {
  input: 'src/index.js',
  output: [
    { file: pkg.main, format: 'cjs', sourcemap: true },
    { file: pkg.module, format: 'es', sourcemap: true }
  ],
  plugins: plugins,
  external
};
