#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import abc


__all__ = [
    "DispatcherBase"
]


class DispatcherBase(metaclass=abc.ABCMeta):
    "Base class for dispatcher"

    @abc.abstractmethod
    def dispatch(self, incoming):
        """Dispatch incoming messages to the endpoints and return result

        :param incoming: incoming object for dispatching to the endpoint
        :type incoming: object, depends on endpoint type
        """
