# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class NetworkTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.networks("HWXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://supersim.twilio.com/v1/Networks/HWXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "friendly_name": "AT&T",
                "iso_country": "US",
                "identifiers": [
                    {
                        "mcc": "310",
                        "mnc": "410"
                    }
                ],
                "sid": "HWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "url": "https://supersim.twilio.com/v1/Networks/HWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.supersim.v1.networks("HWXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.networks.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://supersim.twilio.com/v1/Networks',
        ))

    def test_read_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "first_page_url": "https://supersim.twilio.com/v1/Networks?PageSize=50&Page=0",
                    "key": "networks",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/Networks?PageSize=50&Page=0"
                },
                "networks": [
                    {
                        "friendly_name": "AT&T",
                        "iso_country": "US",
                        "identifiers": [
                            {
                                "mcc": "310",
                                "mnc": "410"
                            }
                        ],
                        "sid": "HWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "url": "https://supersim.twilio.com/v1/Networks/HWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ]
            }
            '''
        ))

        actual = self.client.supersim.v1.networks.list()

        self.assertIsNotNone(actual)

    def test_read_with_filters_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "first_page_url": "https://supersim.twilio.com/v1/Networks?IsoCountry=US&Mnc=410&Mcc=310&PageSize=50&Page=0",
                    "key": "networks",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/Networks?IsoCountry=US&Mnc=410&Mcc=310&PageSize=50&Page=0"
                },
                "networks": [
                    {
                        "friendly_name": "AT&T",
                        "iso_country": "US",
                        "identifiers": [
                            {
                                "mcc": "310",
                                "mnc": "410"
                            }
                        ],
                        "sid": "HWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "url": "https://supersim.twilio.com/v1/Networks/HWaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ]
            }
            '''
        ))

        actual = self.client.supersim.v1.networks.list()

        self.assertIsNotNone(actual)
