# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class EventList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, call_sid):
        """
        Initialize the EventList

        :param Version version: Version that contains the resource
        :param call_sid: The call_sid

        :returns: twilio.rest.insights.v1.call.event.EventList
        :rtype: twilio.rest.insights.v1.call.event.EventList
        """
        super(EventList, self).__init__(version)

        # Path Solution
        self._solution = {'call_sid': call_sid, }
        self._uri = '/Voice/{call_sid}/Events'.format(**self._solution)

    def stream(self, edge=values.unset, limit=None, page_size=None):
        """
        Streams EventInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param EventInstance.TwilioEdge edge: The edge
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.insights.v1.call.event.EventInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(edge=edge, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, edge=values.unset, limit=None, page_size=None):
        """
        Lists EventInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param EventInstance.TwilioEdge edge: The edge
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.insights.v1.call.event.EventInstance]
        """
        return list(self.stream(edge=edge, limit=limit, page_size=page_size, ))

    def page(self, edge=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of EventInstance records from the API.
        Request is executed immediately

        :param EventInstance.TwilioEdge edge: The edge
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of EventInstance
        :rtype: twilio.rest.insights.v1.call.event.EventPage
        """
        data = values.of({
            'Edge': edge,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return EventPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of EventInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of EventInstance
        :rtype: twilio.rest.insights.v1.call.event.EventPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return EventPage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1.EventList>'


class EventPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the EventPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param call_sid: The call_sid

        :returns: twilio.rest.insights.v1.call.event.EventPage
        :rtype: twilio.rest.insights.v1.call.event.EventPage
        """
        super(EventPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of EventInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.insights.v1.call.event.EventInstance
        :rtype: twilio.rest.insights.v1.call.event.EventInstance
        """
        return EventInstance(self._version, payload, call_sid=self._solution['call_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1.EventPage>'


class EventInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    class TwilioEdge(object):
        UNKNOWN_EDGE = "unknown_edge"
        CARRIER_EDGE = "carrier_edge"
        SIP_EDGE = "sip_edge"
        SDK_EDGE = "sdk_edge"
        CLIENT_EDGE = "client_edge"

    class Level(object):
        UNKNOWN = "UNKNOWN"
        DEBUG = "DEBUG"
        INFO = "INFO"
        WARNING = "WARNING"
        ERROR = "ERROR"

    def __init__(self, version, payload, call_sid):
        """
        Initialize the EventInstance

        :returns: twilio.rest.insights.v1.call.event.EventInstance
        :rtype: twilio.rest.insights.v1.call.event.EventInstance
        """
        super(EventInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'timestamp': payload.get('timestamp'),
            'call_sid': payload.get('call_sid'),
            'account_sid': payload.get('account_sid'),
            'edge': payload.get('edge'),
            'group': payload.get('group'),
            'level': payload.get('level'),
            'name': payload.get('name'),
            'carrier_edge': payload.get('carrier_edge'),
            'sip_edge': payload.get('sip_edge'),
            'sdk_edge': payload.get('sdk_edge'),
            'client_edge': payload.get('client_edge'),
        }

        # Context
        self._context = None
        self._solution = {'call_sid': call_sid, }

    @property
    def timestamp(self):
        """
        :returns: The timestamp
        :rtype: unicode
        """
        return self._properties['timestamp']

    @property
    def call_sid(self):
        """
        :returns: The call_sid
        :rtype: unicode
        """
        return self._properties['call_sid']

    @property
    def account_sid(self):
        """
        :returns: The account_sid
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def edge(self):
        """
        :returns: The edge
        :rtype: EventInstance.TwilioEdge
        """
        return self._properties['edge']

    @property
    def group(self):
        """
        :returns: The group
        :rtype: unicode
        """
        return self._properties['group']

    @property
    def level(self):
        """
        :returns: The level
        :rtype: EventInstance.Level
        """
        return self._properties['level']

    @property
    def name(self):
        """
        :returns: The name
        :rtype: unicode
        """
        return self._properties['name']

    @property
    def carrier_edge(self):
        """
        :returns: The carrier_edge
        :rtype: dict
        """
        return self._properties['carrier_edge']

    @property
    def sip_edge(self):
        """
        :returns: The sip_edge
        :rtype: dict
        """
        return self._properties['sip_edge']

    @property
    def sdk_edge(self):
        """
        :returns: The sdk_edge
        :rtype: dict
        """
        return self._properties['sdk_edge']

    @property
    def client_edge(self):
        """
        :returns: The client_edge
        :rtype: dict
        """
        return self._properties['client_edge']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights.V1.EventInstance>'
