A control-flow expression was used inside a const context.

Erroneous code example:

```compile_fail,E0744
const _: i32 = {
    let mut x = 0;

    for i in 0..4 { // error!
        x += i;
    }
};
```

At the moment, `if` and `match`, as well as the looping constructs `for`,
`while`, and `loop`, are forbidden inside a `const`, `static`, or `const fn`.

This will be allowed at some point in the future, but the implementation is not
yet complete. See the tracking issue for [conditionals] or [loops] in a const
context for the current status.

[conditionals]: https://github.com/rust-lang/rust/issues/49146
[loops]: https://github.com/rust-lang/rust/issues/52000
