//
#ifndef _vdkchildtask_h
// put your code below here
#define _vdkchildtask_h

#include <vdk/vdkobj.h>
#include <vdk/value_sem_list.h>
#include <vdk/siglisthandle.h>
#include <vdk/vdkinchannel.h>
#define _GNU_SOURCE
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>

#define CHILD_TASK_DATA_SIGNAL (user_signal-1023)
#define CHILD_TASK_DIED_SIGNAL (user_signal-1022)

class VDKChildTask;

class VDKPid
{
  public:
  pid_t pid; 
  VDKChildTask* task;
  VDKPid (pid_t pid = (pid_t) -1,  VDKChildTask* task = NULL);
  ~VDKPid () {}
  bool operator == (VDKPid& p)
    { return (pid ==  p.pid); }
  bool operator < (VDKPid& p)
    { return (pid <  p.pid); }
  
};

typedef VDKValueList <VDKPid> PIDLIST;
typedef VDKValueListIterator <VDKPid> PidListIterator;

class VDKChildTask: public VDKObject
{
  private:
    char* data_buffer;
    static void reaper(int);
    static void plumber(int);
    pid_t  pid;
    int xmit;
    static PIDLIST PidList;
  protected:
    bool DoIO (VDKObject*);

  public: 
  VDKChildTask (VDKForm* owner);
  virtual ~VDKChildTask ();
  pid_t StartChild (char* args[],  bool duplex = false);
  char* GetData () { return data_buffer; }
  bool SendData (char* buffer);
  // hopefully converted into properties
  inline int Pid() {return pid;}
  inline void Pid(int p) {pid = p;}
  inline int Xmit() {return pid;}
  inline void Xmit(int x) {xmit = x;}
  DECLARE_SIGNAL_LIST (VDKChildTask);
  };
// 
#endif

