/* Driver's definitions.

Copyright (C) 1999 Politecnico di Torino

This file is part of the NDIS Packet capture driver.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#define  MAX_REQUESTS   4

#define MAX_PACKET_LENGTH 1514

struct timeval {
        long    tv_sec;         /* seconds */
        long    tv_usec;        /* and microseconds */
};

/*
 * Alignment macros.  Packet_WORDALIGN rounds up to the next 
 * even multiple of Packet_ALIGNMENT. 
 */
#define Packet_ALIGNMENT sizeof(int)
#define Packet_WORDALIGN(x) (((x)+(Packet_ALIGNMENT-1))&~(Packet_ALIGNMENT-1))


//IOCTLs
#define	 BIOCSETBUFFERSIZE 9592
#define	 BIOCSETF 9030
#define  BIOCGSTATS 9031
#define  BIORELEASEREQUESTS 7412

struct bpf_insn {
	USHORT	code;
	UCHAR 	jt;
	UCHAR 	jf;
	int k;
};

struct bpf_hdr {
	struct timeval	bh_tstamp;	/* time stamp */
	UINT	bh_caplen;	/* length of captured portion */
	UINT	bh_datalen;	/* original length of packet */
	USHORT		bh_hdrlen;	/* length of bpf header (this struct
					   plus alignment padding) */
};

#define MAX_BUFFER_SPACE MAX_PACKET_LENGTH+sizeof(struct bpf_hdr)


typedef struct _INTERNAL_REQUEST {
    LIST_ENTRY     ListElement;
    PIRP           Irp;
    NDIS_REQUEST   Request;

    } INTERNAL_REQUEST, *PINTERNAL_REQUEST;



//
// Port device extension.
//

typedef struct _DEVICE_EXTENSION {

    PDEVICE_OBJECT DeviceObject;

    NDIS_HANDLE    NdisProtocolHandle;

    NDIS_STRING    AdapterName;

    PWSTR          BindString;
    PWSTR          ExportString;


} DEVICE_EXTENSION, *PDEVICE_EXTENSION;

typedef struct _OPEN_INSTANCE
    {
        PDEVICE_EXTENSION   DeviceExtension;
        NDIS_HANDLE         AdapterHandle;
        NDIS_HANDLE         PacketPool;
//        NDIS_SPIN_LOCK      RcvQSpinLock;
KSPIN_LOCK      RcvQSpinLock;
        LIST_ENTRY          RcvList;
        PIRP                OpenCloseIrp;
//        NDIS_SPIN_LOCK      RequestSpinLock;
KSPIN_LOCK      RequestSpinLock;
        LIST_ENTRY          RequestList;
        LIST_ENTRY          ResetIrpList;
        INTERNAL_REQUEST    Requests[MAX_REQUESTS];
		PUCHAR				Buffer;
		int					Dropped;			
		int					Received;
		PUCHAR				bpfprogram;
		LARGE_INTEGER		StartTime;  
		UINT				Bhead;
		UINT				Btail;
		UINT				BufSize;
		UINT				BLastByte;

    } OPEN_INSTANCE, *POPEN_INSTANCE;



typedef struct _PACKET_RESERVED {
    LIST_ENTRY     ListElement;
    PIRP           Irp;
    PMDL           pMdl;
    }  PACKET_RESERVED, *PPACKET_RESERVED;



#define  ETHERNET_HEADER_LENGTH   14

#define RESERVED(_p) ((PPACKET_RESERVED)((_p)->ProtocolReserved))

#define  TRANSMIT_PACKETS    16





VOID
PacketOpenAdapterComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status,
    IN NDIS_STATUS  OpenErrorStatus
    );

VOID
PacketCloseAdapterComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status
    );


NDIS_STATUS
Packet_tap(
    IN NDIS_HANDLE ProtocolBindingContext,
    IN NDIS_HANDLE MacReceiveContext,
    IN PVOID HeaderBuffer,
    IN UINT HeaderBufferSize,
    IN PVOID LookAheadBuffer,
    IN UINT LookaheadBufferSize,
    IN UINT PacketSize
    );

VOID
PacketReceiveComplete(
    IN NDIS_HANDLE  ProtocolBindingContext
    );


VOID
PacketRequestComplete(
    IN NDIS_HANDLE   ProtocolBindingContext,
    IN PNDIS_REQUEST pRequest,
    IN NDIS_STATUS   Status
    );

VOID
PacketSendComplete(
    IN NDIS_HANDLE   ProtocolBindingContext,
    IN PNDIS_PACKET  pPacket,
    IN NDIS_STATUS   Status
    );


VOID
PacketResetComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status
    );


VOID
PacketStatus(
    IN NDIS_HANDLE   ProtocolBindingContext,
    IN NDIS_STATUS   Status,
    IN PVOID         StatusBuffer,
    IN UINT          StatusBufferSize
    );


VOID
PacketStatusComplete(
    IN NDIS_HANDLE  ProtocolBindingContext
    );

VOID
PacketTransferDataComplete(
    IN NDIS_HANDLE ProtocolBindingContext,
    IN PNDIS_PACKET Packet,
    IN NDIS_STATUS Status,
    IN UINT BytesTransferred
    );


VOID
PacketRemoveReference(
    IN PDEVICE_EXTENSION DeviceExtension
    );


NTSTATUS
PacketCleanup(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP FlushIrp
    );


NTSTATUS
PacketShutdown(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

VOID
PacketUnload(
    IN PDRIVER_OBJECT DriverObject
    );



NTSTATUS
PacketOpen(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

NTSTATUS
PacketClose(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

NTSTATUS
PacketWrite(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

NTSTATUS
PacketRead(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

NTSTATUS
PacketIoControl(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    );

int bpf_validate(struct bpf_insn *f,int len);

UINT bpf_filter(register struct bpf_insn *pc,
				register UCHAR *p,
				UINT wirelen,
				register UINT buflen);

UINT bpf_filter_with_2_buffers(register struct bpf_insn *pc,
							   register UCHAR *p,
							   register UCHAR *pd,
							   register int headersize,
							   UINT wirelen,
							   register UINT buflen);