(require 'fxrd-mode)
(require 'fxrd-validators)

;;; American Express chargeback notification file

(defconst cbnot-spec
;;; NOTE: many of these should be numeric types, but amex docs specify them as alphanumeric

  ;; File Header Record
  `(("H" (
          (1 1 "REC TYPE (H)" ,(fxrd-alphanumeric-v :const "H"))
          (2 3 "APPLICATION SYSTEM CODE" ,(fxrd-alphanumeric-v))
          (4 5 "FILE TYPE CODE" ,(fxrd-alphanumeric-v))
          (6 13 "FILE CREATION DATE" ,(fxrd-alphanumeric-v))
          (14 101 "FILLER" ,(fxrd-alphanumeric-v :reserved t))
          (102 107 "SERVICE ACCESS ID" ,(fxrd-alphanumeric-v))
          (108 112 "DATATYPE" ,(fxrd-alphanumeric-v :const "CBNOT"))
          (113 119 "CCYYDDD (Date)" ,(fxrd-alphanumeric-v))
          (120 126 "0HHMMSS (File creation time)" ,(fxrd-numeric-v))
          (127 2202 "FILLER" ,(fxrd-alphanumeric-v :reserved t))))
    ("D" (
          (1 1 "REC TYPE (D)" ,(fxrd-alphanumeric-v :const "D"))
          (2 6 "FILLER" ,(fxrd-alphanumeric-v :reserved t))
          (7 16 "SE NUMB" ,(fxrd-alphanumeric-v))
          (17 26 "FILLER" ,(fxrd-alphanumeric-v :reserved t))
          (27 41 "CM ACCT NUMB" ,(fxrd-alphanumeric-v))
          (42 46 "FILLER" ,(fxrd-alphanumeric-v :reserved t))
          (47 57 "CURRENT CASE NUMBER/CSS CASE NUMBER/SS CASE NUMBER/FINCAP TRACKING ID"
              ,(fxrd-alphanumeric-v))
          (58 59 "CURRENT ACTION NUMBER" ,(fxrd-alphanumeric-v))
          (60 70 "PREVIOUS CASE NUMBER/CSS_P_CASE_NUMBER" ,(fxrd-alphanumeric-v))
          (71 72 "PREVIOUS ACTION NUMBER" ,(fxrd-alphanumeric-v))
          (73 73 "RESOLUTION" ,(fxrd-alphanumeric-v :enum '("Y" "N")))
          ;; TODO: map these to useful strings
          (74 74 "FROM SYSTEM" ,(fxrd-alphanumeric-v :enum '("F" "R" "S" "T" "X" "P" "G" " ")))
          (75 75 "REJECTS TO SYSTEM" ,(fxrd-alphanumeric-v :enum '("R" "S" "T" "X" "P" "G" " ")))
          (76 76 "DISPUTES TO SYSTEM" ,(fxrd-alphanumeric-v :enum '("R" "S" "T" "X" "P" "G" " ")))
          (77 84 "DATE OF ADJUSTMENT (CCYYMMDD)" ,(fxrd-alphanumeric-v))
          (85 92 "DATE OF CHARGE (CCYYMMDD)" ,(fxrd-alphanumeric-v))
          (93 99 "AMEX ID" ,(fxrd-alphanumeric-v))
          (100 104 "FILLER")
          (105 110 "CASE TYPE" ,(fxrd-alphanumeric-v
                                 :enum '("AIRDS" "AIRLT" "AIRRT" "AIRTB" "AREXS" "CARRD"
                                         "GSDIS" "NAXMG" "NAXMR" "SEDIS" "FRAUD" "CRCDW")))
          (111 125 "LOC NUMB" ,(fxrd-alphanumeric-v))
          (126 128 "CB REAS CODE"
               ,(fxrd-alphanumeric-v
                 :enum '("A01" "A02" "A08" "C02" "C04" "C05" "C08" "C14" "C18"
                         "C28" "C31" "C32" "F10" "F14" "F22" "F24" "F29" "FR2"
                         "FR4" "FR6" "M01" "M10" "M49" "P01" "P03" "P04" "P05"
                         "P07" "P08" "P22" "P23" "R03" "R13" "M11" "M38" "M19"
                         "M21" "M22" "M23" "M24" "M25" "M27" "M28" "M29" "M32"
                         "M33" "M39" "M43" "M44" "M45" "M46" "P09" "FR5" "M02"
                         "M04" "M36" "M42" "S01" "S03" "S04")))
          (129 145 "CB AMOUNT" ,(fxrd-decimal-v))
          (146 151 "CB ADJUSTMENT NUMBER" ,(fxrd-alphanumeric-v))
          (152 157 "CB RESOLUTION ADJ NUMBER" ,(fxrd-alphanumeric-v))
          (158 169 "CB REFERENCE CODE" ,(fxrd-alphanumeric-v))
          (170 182 "FILLER")
          (183 199 "BILLED AMOUNT" ,(fxrd-decimal-v :pad " "))
          (200 216 "SOC AMOUNT" ,(fxrd-decimal-v :pad " "))
          (217 222 "SOC INVOICE NUMBER" ,(fxrd-alphanumeric-v))
          (223 228 "ROC INVOICE NUMBER" ,(fxrd-alphanumeric-v))
          (229 243 "FOREIGN AMT" ,(fxrd-alphanumeric-v))
          (244 246 "CURRENCY" ,(fxrd-alphanumeric-v :enum '("CAD" "USD" "   ")))
          (247 247 "SUPP TO FOLLOW" ,(fxrd-alphanumeric-v :enum '("Y" "I" "R" "N" " ")))
          (248 277 "CM NAME1" ,(fxrd-alphanumeric-v))
          (278 307 "CM NAME2" ,(fxrd-alphanumeric-v))
          (308 337 "CM ADDR1" ,(fxrd-alphanumeric-v))
          (338 367 "CM ADDR2" ,(fxrd-alphanumeric-v))
          (368 397 "CM CITY STATE" ,(fxrd-alphanumeric-v))
          (398 406 "CM ZIP" ,(fxrd-alphanumeric-v))
          (407 418 "CM FIRST NAME 1" ,(fxrd-alphanumeric-v))
          (419 430 "CM MIDDLE NAME 1" ,(fxrd-alphanumeric-v))
          (431 450 "CM LAST NAME 1" ,(fxrd-alphanumeric-v))
          (451 465 "CM ORIG ACCT NUM" ,(fxrd-alphanumeric-v))
          (466 495 "CM ORIG NAME" ,(fxrd-alphanumeric-v))
          (496 507 "CM ORIG FIRST NAME" ,(fxrd-alphanumeric-v))
          (508 519 "CM ORIG MIDDLE NAME" ,(fxrd-alphanumeric-v))
          (520 539 "CM ORIG LAST NAME" ,(fxrd-alphanumeric-v))
          (540 605 "NOTE1" ,(fxrd-alphanumeric-v))
          (606 683 "NOTE2" ,(fxrd-alphanumeric-v))
          (684 743 "NOTE3" ,(fxrd-alphanumeric-v))
          (744 803 "NOTE4" ,(fxrd-alphanumeric-v))
          (804 863 "NOTE5" ,(fxrd-alphanumeric-v))
          (864 923 "NOTE6" ,(fxrd-alphanumeric-v))
          (924 983 "NOTE7" ,(fxrd-alphanumeric-v))
          (984 985 "TRIUMPH SEQ NO" ,(fxrd-alphanumeric-v))
          (986 1005 "FILLER")
          (1006 1020 "SERVICE AGENT MERCHANT ID/FILLER" ,(fxrd-alphanumeric-v))
          (1021 1030 "FILLER")
          (1031 1044 "AIRLINE_TKT_NUM" ,(fxrd-alphanumeric-v))
          (1045 1046 "AL SEQUENCE NUMBER" ,(fxrd-alphanumeric-v))
          (1047 1064 "FOLIO REF" ,(fxrd-alphanumeric-v))
          (1065 1074 "MERCH ORDER NUM" ,(fxrd-alphanumeric-v))
          (1075 1082 "MERCH ORDER DATE (CCYYMMDD)" ,(fxrd-alphanumeric-v))
          (1083 1102 "CANC NUM" ,(fxrd-alphanumeric-v))
          (1103 1110 "CANC DATE (CCYYMMDD)" ,(fxrd-alphanumeric-v))
          (1111 1121 "FINCAP TRACKING ID" ,(fxrd-alphanumeric-v))
          (1122 1127 "FINCAP FILE SEQ NUM" ,(fxrd-alphanumeric-v))
          (1128 1131 "FINCAP BATCH NUMBER" ,(fxrd-alphanumeric-v))
          (1132 1139 "FINCAP BATCH INVOICE DT" ,(fxrd-alphanumeric-v))
          (1140 1164 "LABEL1" ,(fxrd-alphanumeric-v))
          (1165 1189 "DATA1" ,(fxrd-alphanumeric-v))
          (1190 1214 "LABEL2" ,(fxrd-alphanumeric-v))
          (1215 1239 "DATA2" ,(fxrd-alphanumeric-v))
          (1340 1264 "LABEL3" ,(fxrd-alphanumeric-v))
          (1265 1289 "DATA3" ,(fxrd-alphanumeric-v))
          (1290 1314 "LABEL4" ,(fxrd-alphanumeric-v))
          (1315 1339 "DATA4" ,(fxrd-alphanumeric-v))
          (1340 1364 "LABEL5" ,(fxrd-alphanumeric-v))
          (1365 1389 "DATA5" ,(fxrd-alphanumeric-v))
          (1390 1414 "LABEL6" ,(fxrd-alphanumeric-v))
          (1415 1439 "DATA6" ,(fxrd-alphanumeric-v))
          (1440 1464 "LABEL7" ,(fxrd-alphanumeric-v))
          (1465 1489 "DATA7" ,(fxrd-alphanumeric-v))
          (1490 1514 "LABEL8" ,(fxrd-alphanumeric-v))
          (1515 1539 "DATA8" ,(fxrd-alphanumeric-v))
          (1540 1564 "LABEL9" ,(fxrd-alphanumeric-v))
          (1565 1589 "DATA9" ,(fxrd-alphanumeric-v))
          (1590 1614 "LABEL10" ,(fxrd-alphanumeric-v))
          (1615 1639 "DATA10" ,(fxrd-alphanumeric-v))
          (1640 1664 "LABEL11" ,(fxrd-alphanumeric-v))
          (1665 1689 "DATA11" ,(fxrd-alphanumeric-v))
          (1690 1714 "LABEL12" ,(fxrd-alphanumeric-v))
          (1715 1739 "DATA12" ,(fxrd-alphanumeric-v))
          (1740 1765 "FILLER")
          (1766 1767 "IND FORM CODE" ,(fxrd-alphanumeric-v :enum '("GP" "NP" "GO" "  ")))
          (1768 1797 "IND REF NUMBER" ,(fxrd-alphanumeric-v))
          (1798 1800 "FILLER")
          (1801 1815 "LOC REF NUMBER" ,(fxrd-alphanumeric-v))
          (1816 1835 "PASSENGER NAME" ,(fxrd-alphanumeric-v))
          (1836 1847 "PASSENGER FIRST NAME" ,(fxrd-alphanumeric-v))
          (1848 1859 "PASSENGER MIDDLE NAME" ,(fxrd-alphanumeric-v))
          (1860 1879 "PASSENGER LAST NAME" ,(fxrd-alphanumeric-v))
          (1880 1882 "SE PROCESS DATE" ,(fxrd-alphanumeric-v))
          (1883 1888 "RETURN DATE" ,(fxrd-alphanumeric-v))
          (1889 1903 "CREDIT RECEIPT NUMBER" ,(fxrd-alphanumeric-v))
          (1904 1927 "RETURN TO NAME" ,(fxrd-alphanumeric-v))
          (1928 1944 "RETURN TO STREET" ,(fxrd-alphanumeric-v))
          (1945 1945 "CARD DEPOSIT" ,(fxrd-alphanumeric-v :enum '("Y" "N" "U" " ")))
          (1946 1946 "ASSURED RESERVATION" ,(fxrd-alphanumeric-v :enum '("Y" "N" " ")))
          (1947 1947 "RES CANCELLED" ,(fxrd-alphanumeric-v :enum '("Y" "N" " ")))
          (1948 1953 "RES CANCELLED DATE" ,(fxrd-alphanumeric-v))
          (1954 1954 "CANCEL ZONE" ,(fxrd-alphanumeric-v :enum '("C" "E" "M" "P" "O" " ")))
          (1955 1960 "RESERVATION MADE FOR" ,(fxrd-alphanumeric-v))
          (1961 1980 "RESERVATION LOCATION" ,(fxrd-alphanumeric-v))
          (1981 1986 "RESERVATION MADE ON" ,(fxrd-alphanumeric-v))
          (1987 2004 "RENTAL AGREEMENT NUMBER" ,(fxrd-alphanumeric-v))
          (2005 2024 "MERCHANDISE TYPE" ,(fxrd-alphanumeric-v))
          (2025 2025 "MERCHANDISE RETURNED" ,(fxrd-alphanumeric-v :enum '("Y" "N" " ")))
          (2026 2049 "RETURNED NAME" ,(fxrd-alphanumeric-v))
          (2050 2055 "RETURNED DATE" ,(fxrd-alphanumeric-v))
          (2056 2063 "RETURNED HOW" ,(fxrd-alphanumeric-v))
          (2064 2113 "RETURNED REASON" ,(fxrd-alphanumeric-v))
          (2114 2114 "STORE CREDIT RECEIVED" ,(fxrd-alphanumeric-v :enum '("Y" "N" " ")))
          (2115 2129 "FILLER")
          (2130 2202 "FILLER")))
    ("T" (
          (1 1 "REC TYPE (T)" ,(fxrd-alphanumeric-v :const "T"))
          (2 3 "APPLICATION SYSTEM CODE" ,(fxrd-numeric-v :const 1))
          (4 5 "FILE TYPE CODE" ,(fxrd-numeric-v :const 1))
          (6 13 "FILE CREATION DATE" ,(fxrd-alphanumeric-v))
          (14 19 "FILLER")
          (20 21 "FILE SEQUENCE NUMBER" ,(fxrd-numeric-v))
          (22 26 "JULIAN DATE" ,(fxrd-alphanumeric-v))
          (27 35 "AMEX TOTAL RECORDS" ,(fxrd-numeric-v))
          (36 44 "CONFIRM RECORD COUNT" ,(fxrd-numeric-v))
          (45 49 "AMEX JOB NUMBER" ,(fxrd-alphanumeric-v))
          (50 101 "FILLER")
          (102 107 "SAID" ,(fxrd-alphanumeric-v))
          (108 112 "DATATYPE" ,(fxrd-alphanumeric-v :const "CBNOT"))
          (113 119 "FILE CREATION DATE (CCYYDD)" ,(fxrd-alphanumeric-v))
          (120 126 "FILE CREATION TIME (0HHMMSS)" ,(fxrd-alphanumeric-v))
          (127 129 "STARS FILESEQ NB" ,(fxrd-numeric-v :const 1))
          (130 2202 "FILLER")))))


;;;###autoload
(define-derived-mode cbnot-mode fxrd-mode "CBNOT"
"Major mode for editing CBNOT fixed field width files.

\\{fxrd-mode-map}"
(setq fxrd-current-spec cbnot-spec))
;;;###autoload(add-to-list 'auto-mode-alist '("\\.cbnot\\($\\|\\.\\)" . cbnot-mode))

(provide 'cbnot-mode)
