/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeConsumer;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;

final class MaxFragExtension {
    static final HandshakeProducer chNetworkProducer = new CHMaxFragmentLengthProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHMaxFragmentLengthConsumer();
    static final HandshakeProducer shNetworkProducer = new SHMaxFragmentLengthProducer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHMaxFragmentLengthConsumer();
    static final HandshakeConsumer shOnTradeConsumer = new SHMaxFragmentLengthUpdate();
    static final HandshakeProducer eeNetworkProducer = new EEMaxFragmentLengthProducer();
    static final SSLExtension.ExtensionConsumer eeOnLoadConsumer = new EEMaxFragmentLengthConsumer();
    static final HandshakeConsumer eeOnTradeConsumer = new EEMaxFragmentLengthUpdate();
    static final SSLStringizer maxFragLenStringizer = new MaxFragLenStringizer();

    MaxFragExtension() {
    }

    private static final class CHMaxFragmentLengthConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHMaxFragmentLengthConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            MaxFragLenSpec maxFragLenSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_MAX_FRAGMENT_LENGTH)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable max_fragment_length extension", new Object[0]);
                }
                return;
            }
            try {
                maxFragLenSpec = new MaxFragLenSpec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            MaxFragLenEnum maxFragLenEnum = MaxFragLenEnum.valueOf(maxFragLenSpec.id);
            if (maxFragLenEnum == null) {
                serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "the requested maximum fragment length is other than the allowed values");
            }
            serverHandshakeContext.maxFragmentLength = maxFragLenEnum.fragmentSize;
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_MAX_FRAGMENT_LENGTH, maxFragLenSpec);
        }
    }

    private static final class CHMaxFragmentLengthProducer
    implements HandshakeProducer {
        private CHMaxFragmentLengthProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            int n;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_MAX_FRAGMENT_LENGTH)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable max_fragment_length extension", new Object[0]);
                }
                return null;
            }
            if (clientHandshakeContext.isResumption && clientHandshakeContext.resumingSession != null) {
                n = clientHandshakeContext.resumingSession.getNegotiatedMaxFragSize();
            } else if (clientHandshakeContext.sslConfig.maximumPacketSize != 0) {
                n = clientHandshakeContext.sslConfig.maximumPacketSize;
                n -= 325;
            } else {
                n = -1;
            }
            MaxFragLenEnum maxFragLenEnum = MaxFragLenEnum.valueOf(n);
            if (maxFragLenEnum != null) {
                clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_MAX_FRAGMENT_LENGTH, new MaxFragLenSpec(maxFragLenEnum.id));
                return new byte[]{maxFragLenEnum.id};
            }
            clientHandshakeContext.maxFragmentLength = -1;
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("No available max_fragment_length extension can be used for fragment size of " + n + "bytes", new Object[0]);
            }
            return null;
        }
    }

    private static final class EEMaxFragmentLengthConsumer
    implements SSLExtension.ExtensionConsumer {
        private EEMaxFragmentLengthConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            MaxFragLenEnum maxFragLenEnum;
            MaxFragLenSpec maxFragLenSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            MaxFragLenSpec maxFragLenSpec2 = (MaxFragLenSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_MAX_FRAGMENT_LENGTH);
            if (maxFragLenSpec2 == null) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected max_fragment_length extension in ServerHello");
            }
            try {
                maxFragLenSpec = new MaxFragLenSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            if (maxFragLenSpec.id != maxFragLenSpec2.id) {
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "The maximum fragment length response is not requested");
            }
            if ((maxFragLenEnum = MaxFragLenEnum.valueOf(maxFragLenSpec.id)) == null) {
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "the requested maximum fragment length is other than the allowed values");
            }
            clientHandshakeContext.maxFragmentLength = maxFragLenEnum.fragmentSize;
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.EE_MAX_FRAGMENT_LENGTH, maxFragLenSpec);
        }
    }

    private static final class EEMaxFragmentLengthProducer
    implements HandshakeProducer {
        private EEMaxFragmentLengthProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            int n;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            MaxFragLenSpec maxFragLenSpec = (MaxFragLenSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_MAX_FRAGMENT_LENGTH);
            if (maxFragLenSpec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable max_fragment_length extension", new Object[0]);
                }
                return null;
            }
            if (serverHandshakeContext.maxFragmentLength > 0 && serverHandshakeContext.sslConfig.maximumPacketSize != 0 && (n = serverHandshakeContext.negotiatedCipherSuite.calculatePacketSize(serverHandshakeContext.maxFragmentLength, serverHandshakeContext.negotiatedProtocol)) > serverHandshakeContext.sslConfig.maximumPacketSize) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Abort the maximum fragment length negotiation, may overflow the maximum packet size limit.", new Object[0]);
                }
                serverHandshakeContext.maxFragmentLength = -1;
            }
            if (serverHandshakeContext.maxFragmentLength > 0) {
                serverHandshakeContext.handshakeSession.setNegotiatedMaxFragSize(serverHandshakeContext.maxFragmentLength);
                serverHandshakeContext.conContext.inputRecord.changeFragmentSize(serverHandshakeContext.maxFragmentLength);
                serverHandshakeContext.conContext.outputRecord.changeFragmentSize(serverHandshakeContext.maxFragmentLength);
                serverHandshakeContext.handshakeExtensions.put(SSLExtension.EE_MAX_FRAGMENT_LENGTH, maxFragLenSpec);
                return new byte[]{maxFragLenSpec.id};
            }
            return null;
        }
    }

    private static final class EEMaxFragmentLengthUpdate
    implements HandshakeConsumer {
        private EEMaxFragmentLengthUpdate() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            int n;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            MaxFragLenSpec maxFragLenSpec = (MaxFragLenSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.EE_MAX_FRAGMENT_LENGTH);
            if (maxFragLenSpec == null) {
                return;
            }
            if (clientHandshakeContext.maxFragmentLength > 0 && clientHandshakeContext.sslConfig.maximumPacketSize != 0 && (n = clientHandshakeContext.negotiatedCipherSuite.calculatePacketSize(clientHandshakeContext.maxFragmentLength, clientHandshakeContext.negotiatedProtocol)) > clientHandshakeContext.sslConfig.maximumPacketSize) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Abort the maximum fragment length negotiation, may overflow the maximum packet size limit.", new Object[0]);
                }
                clientHandshakeContext.maxFragmentLength = -1;
            }
            if (clientHandshakeContext.maxFragmentLength > 0) {
                clientHandshakeContext.handshakeSession.setNegotiatedMaxFragSize(clientHandshakeContext.maxFragmentLength);
                clientHandshakeContext.conContext.inputRecord.changeFragmentSize(clientHandshakeContext.maxFragmentLength);
                clientHandshakeContext.conContext.outputRecord.changeFragmentSize(clientHandshakeContext.maxFragmentLength);
            }
        }
    }

    static enum MaxFragLenEnum {
        MFL_512(1, 512, "2^9"),
        MFL_1024(2, 1024, "2^10"),
        MFL_2048(3, 2048, "2^11"),
        MFL_4096(4, 4096, "2^12");

        final byte id;
        final int fragmentSize;
        final String description;

        private MaxFragLenEnum(byte by, int n2, String string2) {
            this.id = by;
            this.fragmentSize = n2;
            this.description = string2;
        }

        private static MaxFragLenEnum valueOf(byte by) {
            for (MaxFragLenEnum maxFragLenEnum : MaxFragLenEnum.values()) {
                if (maxFragLenEnum.id != by) continue;
                return maxFragLenEnum;
            }
            return null;
        }

        private static String nameOf(byte by) {
            for (MaxFragLenEnum maxFragLenEnum : MaxFragLenEnum.values()) {
                if (maxFragLenEnum.id != by) continue;
                return maxFragLenEnum.description;
            }
            return "UNDEFINED-MAX-FRAGMENT-LENGTH(" + by + ")";
        }

        static MaxFragLenEnum valueOf(int n) {
            if (n <= 0) {
                return null;
            }
            if (n < 1024) {
                return MFL_512;
            }
            if (n < 2048) {
                return MFL_1024;
            }
            if (n < 4096) {
                return MFL_2048;
            }
            if (n == 4096) {
                return MFL_4096;
            }
            return null;
        }
    }

    static final class MaxFragLenSpec
    implements SSLExtension.SSLExtensionSpec {
        byte id;

        private MaxFragLenSpec(byte by) {
            this.id = by;
        }

        private MaxFragLenSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() != 1) {
                throw new SSLProtocolException("Invalid max_fragment_length extension data");
            }
            this.id = byteBuffer.get();
        }

        public String toString() {
            return MaxFragLenEnum.nameOf(this.id);
        }
    }

    private static final class MaxFragLenStringizer
    implements SSLStringizer {
        private MaxFragLenStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new MaxFragLenSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    private static final class SHMaxFragmentLengthConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHMaxFragmentLengthConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            MaxFragLenEnum maxFragLenEnum;
            MaxFragLenSpec maxFragLenSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            MaxFragLenSpec maxFragLenSpec2 = (MaxFragLenSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_MAX_FRAGMENT_LENGTH);
            if (maxFragLenSpec2 == null) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected max_fragment_length extension in ServerHello");
            }
            try {
                maxFragLenSpec = new MaxFragLenSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            if (maxFragLenSpec.id != maxFragLenSpec2.id) {
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "The maximum fragment length response is not requested");
            }
            if ((maxFragLenEnum = MaxFragLenEnum.valueOf(maxFragLenSpec.id)) == null) {
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "the requested maximum fragment length is other than the allowed values");
            }
            clientHandshakeContext.maxFragmentLength = maxFragLenEnum.fragmentSize;
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.SH_MAX_FRAGMENT_LENGTH, maxFragLenSpec);
        }
    }

    private static final class SHMaxFragmentLengthProducer
    implements HandshakeProducer {
        private SHMaxFragmentLengthProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            int n;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            MaxFragLenSpec maxFragLenSpec = (MaxFragLenSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_MAX_FRAGMENT_LENGTH);
            if (maxFragLenSpec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable max_fragment_length extension", new Object[0]);
                }
                return null;
            }
            if (serverHandshakeContext.maxFragmentLength > 0 && serverHandshakeContext.sslConfig.maximumPacketSize != 0 && (n = serverHandshakeContext.negotiatedCipherSuite.calculatePacketSize(serverHandshakeContext.maxFragmentLength, serverHandshakeContext.negotiatedProtocol)) > serverHandshakeContext.sslConfig.maximumPacketSize) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Abort the maximum fragment length negotiation, may overflow the maximum packet size limit.", new Object[0]);
                }
                serverHandshakeContext.maxFragmentLength = -1;
            }
            if (serverHandshakeContext.maxFragmentLength > 0) {
                serverHandshakeContext.handshakeSession.setNegotiatedMaxFragSize(serverHandshakeContext.maxFragmentLength);
                serverHandshakeContext.conContext.inputRecord.changeFragmentSize(serverHandshakeContext.maxFragmentLength);
                serverHandshakeContext.conContext.outputRecord.changeFragmentSize(serverHandshakeContext.maxFragmentLength);
                serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_MAX_FRAGMENT_LENGTH, maxFragLenSpec);
                return new byte[]{maxFragLenSpec.id};
            }
            return null;
        }
    }

    private static final class SHMaxFragmentLengthUpdate
    implements HandshakeConsumer {
        private SHMaxFragmentLengthUpdate() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            int n;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            MaxFragLenSpec maxFragLenSpec = (MaxFragLenSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.SH_MAX_FRAGMENT_LENGTH);
            if (maxFragLenSpec == null) {
                return;
            }
            if (clientHandshakeContext.maxFragmentLength > 0 && clientHandshakeContext.sslConfig.maximumPacketSize != 0 && (n = clientHandshakeContext.negotiatedCipherSuite.calculatePacketSize(clientHandshakeContext.maxFragmentLength, clientHandshakeContext.negotiatedProtocol)) > clientHandshakeContext.sslConfig.maximumPacketSize) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Abort the maximum fragment length negotiation, may overflow the maximum packet size limit.", new Object[0]);
                }
                clientHandshakeContext.maxFragmentLength = -1;
            }
            if (clientHandshakeContext.maxFragmentLength > 0) {
                clientHandshakeContext.handshakeSession.setNegotiatedMaxFragSize(clientHandshakeContext.maxFragmentLength);
                clientHandshakeContext.conContext.inputRecord.changeFragmentSize(clientHandshakeContext.maxFragmentLength);
                clientHandshakeContext.conContext.outputRecord.changeFragmentSize(clientHandshakeContext.maxFragmentLength);
            }
        }
    }
}

